rule win_lambert_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lambert."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lambert"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bd8 0f82a4000000 83fe06 0f822cffffff }
            // n = 4, score = 400
            //   3bd8                 | cmp                 ebx, eax
            //   0f82a4000000         | jb                  0xaa
            //   83fe06               | cmp                 esi, 6
            //   0f822cffffff         | jb                  0xffffff32

        $sequence_1 = { 3315???????? 05f0000000 832000 33f2 8b55e8 33ce 33d1 }
            // n = 7, score = 400
            //   3315????????         |                     
            //   05f0000000           | add                 eax, 0xf0
            //   832000               | and                 dword ptr [eax], 0
            //   33f2                 | xor                 esi, edx
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   33ce                 | xor                 ecx, esi
            //   33d1                 | xor                 edx, ecx

        $sequence_2 = { 42 42 3bf9 0f84a8000000 81ef00400000 }
            // n = 5, score = 400
            //   42                   | inc                 edx
            //   42                   | inc                 edx
            //   3bf9                 | cmp                 edi, ecx
            //   0f84a8000000         | je                  0xae
            //   81ef00400000         | sub                 edi, 0x4000

        $sequence_3 = { 55 8bec 56 8b7510 c1fe04 }
            // n = 5, score = 400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   56                   | push                esi
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   c1fe04               | sar                 esi, 4

        $sequence_4 = { 2bc1 3bc7 0f82e5010000 8b4508 2bc2 8d7701 }
            // n = 6, score = 400
            //   2bc1                 | sub                 eax, ecx
            //   3bc7                 | cmp                 eax, edi
            //   0f82e5010000         | jb                  0x1eb
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   2bc2                 | sub                 eax, edx
            //   8d7701               | lea                 esi, [edi + 1]

        $sequence_5 = { 4e 8b1f 8919 2bf0 }
            // n = 4, score = 400
            //   4e                   | dec                 esi
            //   8b1f                 | mov                 ebx, dword ptr [edi]
            //   8919                 | mov                 dword ptr [ecx], ebx
            //   2bf0                 | sub                 esi, eax

        $sequence_6 = { 33f1 8b4de4 33ce 314de8 }
            // n = 4, score = 400
            //   33f1                 | xor                 esi, ecx
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   33ce                 | xor                 ecx, esi
            //   314de8               | xor                 dword ptr [ebp - 0x18], ecx

        $sequence_7 = { 3bd8 0f826f010000 8a07 8801 41 }
            // n = 5, score = 400
            //   3bd8                 | cmp                 ebx, eax
            //   0f826f010000         | jb                  0x175
            //   8a07                 | mov                 al, byte ptr [edi]
            //   8801                 | mov                 byte ptr [ecx], al
            //   41                   | inc                 ecx

        $sequence_8 = { 8b55f4 8b4220 50 e8???????? 8945f8 }
            // n = 5, score = 300
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b4220               | mov                 eax, dword ptr [edx + 0x20]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_9 = { 8b4814 894df0 8b550c 8b4508 034220 }
            // n = 5, score = 300
            //   8b4814               | mov                 ecx, dword ptr [eax + 0x14]
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   034220               | add                 eax, dword ptr [edx + 0x20]

        $sequence_10 = { 03481c 894de4 8b55f4 8b45e4 }
            // n = 4, score = 300
            //   03481c               | add                 ecx, dword ptr [eax + 0x1c]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_11 = { c1e90d 8b55f8 c1e213 0bca 894df8 8b45fc 0fbe08 }
            // n = 7, score = 300
            //   c1e90d               | shr                 ecx, 0xd
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   c1e213               | shl                 edx, 0x13
            //   0bca                 | or                  ecx, edx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0fbe08               | movsx               ecx, byte ptr [eax]

        $sequence_12 = { 7502 eb0b 8b55fc 83c201 8955fc }
            // n = 5, score = 300
            //   7502                 | jne                 4
            //   eb0b                 | jmp                 0xd
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c201               | add                 edx, 1
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_13 = { 8945ec 8b4d0c 8b5508 035124 8955f8 }
            // n = 5, score = 300
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   035124               | add                 edx, dword ptr [ecx + 0x24]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

        $sequence_14 = { 83c078 8945f0 8b4df0 83790400 7502 eb4c 8b55f0 }
            // n = 7, score = 300
            //   83c078               | add                 eax, 0x78
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83790400             | cmp                 dword ptr [ecx + 4], 0
            //   7502                 | jne                 4
            //   eb4c                 | jmp                 0x4e
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]

        $sequence_15 = { 0fb70c50 894df0 eb02 ebb8 }
            // n = 4, score = 300
            //   0fb70c50             | movzx               ecx, word ptr [eax + edx*2]
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   eb02                 | jmp                 4
            //   ebb8                 | jmp                 0xffffffba

    condition:
        7 of them and filesize < 1212416
}