rule win_lcpdot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lcpdot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lcpdot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? c705????????01000000 e8???????? 83f801 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   c705????????01000000     |     
            //   e8????????           |                     
            //   83f801               | cmp                 eax, 1

        $sequence_1 = { 41b804000000 e8???????? 85c0 400f94c6 8bc6 488bac24a8080000 4c8ba42460080000 }
            // n = 7, score = 100
            //   41b804000000         | test                eax, eax
            //   e8????????           |                     
            //   85c0                 | jne                 0x1d
            //   400f94c6             | inc                 ecx
            //   8bc6                 | mov                 eax, 4
            //   488bac24a8080000     | test                eax, eax
            //   4c8ba42460080000     | inc                 eax

        $sequence_2 = { 8b4e10 51 ffd7 5f 5e c3 55 }
            // n = 7, score = 100
            //   8b4e10               | mov                 dword ptr [esp + 0x28], 0x80
            //   51                   | dec                 eax
            //   ffd7                 | mov                 dword ptr [esp + 0x68], ebp
            //   5f                   | mov                 ecx, 0x40
            //   5e                   | mov                 edx, ebx
            //   c3                   | dec                 esp
            //   55                   | mov                 dword ptr [esp + 0x250], esp

        $sequence_3 = { e8???????? 488d542420 488bcb 41b8e8030000 e8???????? b801000000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488d542420           | mov                 ebx, eax
            //   488bcb               | dec                 eax
            //   41b8e8030000         | mov                 eax, dword ptr [ebx + 0x48]
            //   e8????????           |                     
            //   b801000000           | dec                 eax

        $sequence_4 = { 8b95a8fbffff 89480c 895010 897014 897818 a1???????? }
            // n = 6, score = 100
            //   8b95a8fbffff         | mov                 dword ptr [ebp - 0x220], 0x6128a048
            //   89480c               | mov                 dword ptr [ebp - 0x21c], 0xb10f0682
            //   895010               | lea                 eax, [esi + 0x20]
            //   897014               | add                 esp, 0xc
            //   897818               | lea                 edx, [eax + 2]
            //   a1????????           |                     

        $sequence_5 = { 51 c785f8f3ffff80f10000 ff15???????? 391f 7515 5f 5e }
            // n = 7, score = 100
            //   51                   | mov                 dword ptr [ebp + 0x158], 0xa384282
            //   c785f8f3ffff80f10000     | mov    dword ptr [ebp + 0x15c], 0xef82bb8
            //   ff15????????         |                     
            //   391f                 | mov                 dword ptr [ebp + 0x160], 0x2b413101
            //   7515                 | cmp                 eax, 1
            //   5f                   | mov                 dword ptr [ebp - 0x228], 0xd25b4d48
            //   5e                   | mov                 dword ptr [ebp - 0x224], 0x2a1c0703

        $sequence_6 = { 57 4883ec20 488b7940 4c8bc2 488bd9 488b5708 }
            // n = 6, score = 100
            //   57                   | mov                 esp, dword ptr [esp + 0x860]
            //   4883ec20             | dec                 eax
            //   488b7940             | mov                 edx, 0x4bc6a7ee
            //   4c8bc2               | aaa                 
            //   488bd9               | mov                 dword ptr [ecx], eax
            //   488b5708             | dec                 esp

        $sequence_7 = { 8a4001 3a4101 752b 57 ff15???????? }
            // n = 5, score = 100
            //   8a4001               | mov                 dword ptr [ebp + 0x148], 0x2d90e0d1
            //   3a4101               | mov                 dword ptr [ebp + 0x14c], 0xf6f7db01
            //   752b                 | mov                 dword ptr [ebp + 0x150], 0x8d460d08
            //   57                   | mov                 dword ptr [ebp + 0x154], 0x5fcfe0b8
            //   ff15????????         |                     

        $sequence_8 = { 8d4620 83c40c 8d5002 8d9b00000000 668b08 83c002 }
            // n = 6, score = 100
            //   8d4620               | xor                 ecx, ecx
            //   83c40c               | dec                 eax
            //   8d5002               | mov                 dword ptr [esp + 0x30], 0
            //   8d9b00000000         | inc                 ebp
            //   668b08               | lea                 eax, [ecx + 3]
            //   83c002               | mov                 edx, 0x40000000

        $sequence_9 = { 8bd0 8bf0 ff15???????? 488bd8 4885c0 751b }
            // n = 6, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   4885c0               | mov                 ebx, eax
            //   751b                 | dec                 eax

        $sequence_10 = { e8???????? 48baeea7c64b37894100 4c8bd8 488b4348 482bd0 4883fa01 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   48baeea7c64b37894100     | sete    dh
            //   4c8bd8               | mov                 eax, esi
            //   488b4348             | dec                 eax
            //   482bd0               | mov                 ebp, dword ptr [esp + 0x8a8]
            //   4883fa01             | dec                 esp

        $sequence_11 = { dc35???????? 8b3d???????? dd9dacfbffff 33c0 }
            // n = 4, score = 100
            //   dc35????????         |                     
            //   8b3d????????         |                     
            //   dd9dacfbffff         | inc                 esp
            //   33c0                 | mov                 esp, ebx

        $sequence_12 = { b940000000 8bd3 4c89a42450020000 448be3 ff15???????? }
            // n = 5, score = 100
            //   b940000000           | dec                 eax
            //   8bd3                 | mov                 edi, dword ptr [ecx + 0x40]
            //   4c89a42450020000     | dec                 esp
            //   448be3               | mov                 eax, edx
            //   ff15????????         |                     

        $sequence_13 = { c785d8fdffff484d5bd2 c785dcfdffff03071c2a c785e0fdffff48a02861 c785e4fdffff82060fb1 }
            // n = 4, score = 100
            //   c785d8fdffff484d5bd2     | inc    ecx
            //   c785dcfdffff03071c2a     | mov    eax, 0x3e8
            //   c785e0fdffff48a02861     | mov    eax, 1
            //   c785e4fdffff82060fb1     | inc    ebp

        $sequence_14 = { 4533c9 48c744243000000000 458d4103 ba00000040 c744242880000000 48896c2468 }
            // n = 6, score = 100
            //   4533c9               | sub                 edx, eax
            //   48c744243000000000     | dec    eax
            //   458d4103             | cmp                 edx, 1
            //   ba00000040           | push                edi
            //   c744242880000000     | dec                 eax
            //   48896c2468           | sub                 esp, 0x20

    condition:
        7 of them and filesize < 257024
}