rule win_leakthemall_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.leakthemall"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 4889742420 4c89442410 0f57c0 0f11442440 48c744245000000000 488d0d74a70200 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4889742420           | dec                 eax
            //   4c89442410           | mov                 ecx, dword ptr [edx + 0x28]
            //   0f57c0               | dec                 eax
            //   0f11442440           | mov                 ebx, dword ptr [edx + 0x20]
            //   48c744245000000000     | dec    eax
            //   488d0d74a70200       | mov                 dword ptr [esp], eax

        $sequence_1 = { c3 c68424f000000000 488bac24c8000000 4881c4d0000000 c3 488b442450 488b4c2470 }
            // n = 7, score = 100
            //   c3                   | mov                 eax, dword ptr [eax + 8]
            //   c68424f000000000     | xorps               xmm0, xmm0
            //   488bac24c8000000     | movups              xmmword ptr [esp + 0x40], xmm0
            //   4881c4d0000000       | dec                 eax
            //   c3                   | mov                 dword ptr [esp + 0x40], eax
            //   488b442450           | dec                 eax
            //   488b4c2470           | mov                 dword ptr [esp + 0x48], ecx

        $sequence_2 = { 488bb42488000000 4889742440 e8???????? 488b442448 4885c0 7474 488b9c2490000000 }
            // n = 7, score = 100
            //   488bb42488000000     | dec                 eax
            //   4889742440           | test                eax, eax
            //   e8????????           |                     
            //   488b442448           | je                  0x1f3
            //   4885c0               | dec                 ecx
            //   7474                 | mov                 eax, ebx
            //   488b9c2490000000     | dec                 eax

        $sequence_3 = { c4c1496df7 c441096cfe c4c1416dff c57a7e6648 c57a7e6e10 c57a7e36 c57a7e7e20 }
            // n = 7, score = 100
            //   c4c1496df7           | call                eax
            //   c441096cfe           | dec                 eax
            //   c4c1416dff           | mov                 eax, dword ptr [esp + 8]
            //   c57a7e6648           | dec                 eax
            //   c57a7e6e10           | mov                 ecx, dword ptr [esp + 0x10]
            //   c57a7e36             | dec                 eax
            //   c57a7e7e20           | mov                 eax, dword ptr [eax + 0x28]

        $sequence_4 = { f20f5ec1 f20f100d???????? f20f59c8 f20f10542450 660f2ed1 0f86de010000 f20f1015???????? }
            // n = 7, score = 100
            //   f20f5ec1             | dec                 eax
            //   f20f100d????????     |                     
            //   f20f59c8             | mov                 dword ptr [esp + 0x58], edx
            //   f20f10542450         | dec                 eax
            //   660f2ed1             | mov                 ebp, dword ptr [esp + 0x30]
            //   0f86de010000         | dec                 eax
            //   f20f1015????????     |                     

        $sequence_5 = { e9???????? 488b4c2418 488d7930 e8???????? 488b542440 488d7a18 4889c8 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b4c2418           | lea                 edx, [0x100157]
            //   488d7930             | dec                 eax
            //   e8????????           |                     
            //   488b542440           | cmp                 ecx, edx
            //   488d7a18             | jne                 0x19d5
            //   4889c8               | mov                 word ptr [eax + 0xb2], 0

        $sequence_6 = { e8???????? 0fb7442416 0fb7c0 48890424 e8???????? 488d050ef51d00 48890424 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb7442416           | dec                 eax
            //   0fb7c0               | mov                 dword ptr [eax + 8], 0x1a
            //   48890424             | dec                 eax
            //   e8????????           |                     
            //   488d050ef51d00       | lea                 ecx, [0x12055d]
            //   48890424             | dec                 eax

        $sequence_7 = { e8???????? 488b442418 ebc7 48c744244800000000 488b6c2420 4883c428 c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b442418           | mov                 eax, dword ptr [eax]
            //   ebc7                 | dec                 eax
            //   48c744244800000000     | mov    dword ptr [esp + 0x38], eax
            //   488b6c2420           | dec                 eax
            //   4883c428             | mov                 eax, dword ptr [esp + 0x20]
            //   c3                   | dec                 eax

        $sequence_8 = { e9???????? 4889542470 4c89442468 488d0558020f00 48890424 48895c2408 4889742410 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4889542470           | dec                 eax
            //   4c89442468           | mov                 ebx, dword ptr [eax + 0x28]
            //   488d0558020f00       | dec                 eax
            //   48890424             | mov                 esi, dword ptr [edx + 0x28]
            //   48895c2408           | dec                 eax
            //   4889742410           | cmp                 dword ptr [eax + 0x20], ecx

        $sequence_9 = { 488d0d65dd0100 48898c2480000000 4889842488000000 488b05???????? 48890424 488d050acd0500 4889442408 }
            // n = 7, score = 100
            //   488d0d65dd0100       | dec                 eax
            //   48898c2480000000     | mov                 dword ptr [esp + 8], 7
            //   4889842488000000     | dec                 eax
            //   488b05????????       |                     
            //   48890424             | mov                 eax, dword ptr [esp + 0x50]
            //   488d050acd0500       | dec                 eax
            //   4889442408           | mov                 dword ptr [esp], eax

    condition:
        7 of them and filesize < 10363904
}