rule win_lightrail_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lightrail."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightrail"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d48bf 6683f919 7707 6683c020 668902 0fb74202 4883c202 }
            // n = 7, score = 100
            //   8d48bf               | jne                 0x1b1
            //   6683f919             | inc                 ecx
            //   7707                 | movzx               eax, word ptr [eax]
            //   6683c020             | add                 edx, ecx
            //   668902               | test                ax, ax
            //   0fb74202             | jne                 0x1c0
            //   4883c202             | inc                 ecx

        $sequence_1 = { 6683c020 668902 0fb74202 4883c202 6685c0 }
            // n = 5, score = 100
            //   6683c020             | inc                 ecx
            //   668902               | mov                 eax, 0x1000
            //   0fb74202             | inc                 ebp
            //   4883c202             | xor                 esi, esi
            //   6685c0               | dec                 eax

        $sequence_2 = { 8bda 4c8d05927d0000 488bf9 488d1550740000 b912000000 e8???????? }
            // n = 6, score = 100
            //   8bda                 | mov                 esp, ecx
            //   4c8d05927d0000       | dec                 ecx
            //   488bf9               | mov                 ebp, eax
            //   488d1550740000       | inc                 ecx
            //   b912000000           | push                edi
            //   e8????????           |                     

        $sequence_3 = { 776a e8???????? 85c0 7428 85db 7524 488d0d36720100 }
            // n = 7, score = 100
            //   776a                 | mov                 dword ptr [ebx + 0xd8], eax
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   7428                 | test                eax, eax
            //   85db                 | je                  0xab
            //   7524                 | je                  0xd9
            //   488d0d36720100       | dec                 eax

        $sequence_4 = { eb49 8a07 4c8d05d354ffff 4b8b8ce010a70100 ffc3 895d9b }
            // n = 6, score = 100
            //   eb49                 | dec                 eax
            //   8a07                 | test                esi, esi
            //   4c8d05d354ffff       | je                  0x3f5
            //   4b8b8ce010a70100     | mov                 edx, 0xffffffff
            //   ffc3                 | dec                 eax
            //   895d9b               | add                 ebx, 8

        $sequence_5 = { 03d8 0fb601 85c0 75f0 0fb6442430 488d4c2430 81f344434241 }
            // n = 7, score = 100
            //   03d8                 | mov                 ecx, eax
            //   0fb601               | dec                 eax
            //   85c0                 | lea                 edx, [0x13145]
            //   75f0                 | dec                 eax
            //   0fb6442430           | add                 esp, 0x28
            //   488d4c2430           | dec                 eax
            //   81f344434241         | sub                 esp, 0x28

        $sequence_6 = { 8d42ff 3bc8 72e6 8d42ff 41894008 }
            // n = 5, score = 100
            //   8d42ff               | lea                 ecx, [0x11f0f]
            //   3bc8                 | dec                 esp
            //   72e6                 | lea                 ecx, [0x13175]
            //   8d42ff               | dec                 esp
            //   41894008             | mov                 eax, eax

        $sequence_7 = { c745e86c6c0000 488d4de0 ffd0 488bd8 4885db 7504 33c0 }
            // n = 7, score = 100
            //   c745e86c6c0000       | jmp                 0x692
            //   488d4de0             | inc                 ebp
            //   ffd0                 | xor                 eax, eax
            //   488bd8               | xor                 edx, edx
            //   4885db               | xor                 ecx, ecx
            //   7504                 | dec                 eax
            //   33c0                 | lea                 ecx, [0x15b50]

        $sequence_8 = { 488d3d4e260100 eb10 488d3d55260100 eb07 }
            // n = 4, score = 100
            //   488d3d4e260100       | mov                 dword ptr [ebx + 0x50], eax
            //   eb10                 | dec                 eax
            //   488d3d55260100       | test                eax, eax
            //   eb07                 | je                  0x10f

        $sequence_9 = { ff9660020000 e9???????? 4883f902 0f85a1feffff }
            // n = 4, score = 100
            //   ff9660020000         | mov                 ecx, dword ptr [edi + eax*8 + 0x1a710]
            //   e9????????           |                     
            //   4883f902             | dec                 ecx
            //   0f85a1feffff         | mov                 esi, ebx

    condition:
        7 of them and filesize < 249856
}