rule win_lolsnif_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lolsnif."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lolsnif"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8908 eb20 bfd2100000 eb19 bfe8000000 eb12 81ff02010000 }
            // n = 7, score = 200
            //   8908                 | mov                 dword ptr [eax], ecx
            //   eb20                 | jmp                 0x22
            //   bfd2100000           | mov                 edi, 0x10d2
            //   eb19                 | jmp                 0x1b
            //   bfe8000000           | mov                 edi, 0xe8
            //   eb12                 | jmp                 0x14
            //   81ff02010000         | cmp                 edi, 0x102

        $sequence_1 = { eb03 897508 8b7d08 3bfe 745e 3bde 7411 }
            // n = 7, score = 200
            //   eb03                 | jmp                 5
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   3bfe                 | cmp                 edi, esi
            //   745e                 | je                  0x60
            //   3bde                 | cmp                 ebx, esi
            //   7411                 | je                  0x13

        $sequence_2 = { 754b 397c2434 742c a1???????? 8b401c 85c0 7506 }
            // n = 7, score = 200
            //   754b                 | jne                 0x4d
            //   397c2434             | cmp                 dword ptr [esp + 0x34], edi
            //   742c                 | je                  0x2e
            //   a1????????           |                     
            //   8b401c               | mov                 eax, dword ptr [eax + 0x1c]
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8

        $sequence_3 = { 8bc3 8935???????? e8???????? ff35???????? ff15???????? f605????????01 }
            // n = 6, score = 200
            //   8bc3                 | mov                 eax, ebx
            //   8935????????         |                     
            //   e8????????           |                     
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   f605????????01       |                     

        $sequence_4 = { ff35???????? ff15???????? 391d???????? 7405 e8???????? be6fd463aa 3935???????? }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   391d????????         |                     
            //   7405                 | je                  7
            //   e8????????           |                     
            //   be6fd463aa           | mov                 esi, 0xaa63d46f
            //   3935????????         |                     

        $sequence_5 = { 50 8d45f4 50 53 6a03 e8???????? 3bc3 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6a03                 | push                3
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx

        $sequence_6 = { ff75f4 6822010000 e9???????? 3d935aaf70 744d 3dd808c373 7437 }
            // n = 7, score = 200
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6822010000           | push                0x122
            //   e9????????           |                     
            //   3d935aaf70           | cmp                 eax, 0x70af5a93
            //   744d                 | je                  0x4f
            //   3dd808c373           | cmp                 eax, 0x73c308d8
            //   7437                 | je                  0x39

        $sequence_7 = { 7510 8d45e8 c745e880969800 897dec }
            // n = 4, score = 200
            //   7510                 | jne                 0x12
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   c745e880969800       | mov                 dword ptr [ebp - 0x18], 0x989680
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi

        $sequence_8 = { 740b 83c704 43 83fb03 72ea eb05 }
            // n = 6, score = 200
            //   740b                 | je                  0xd
            //   83c704               | add                 edi, 4
            //   43                   | inc                 ebx
            //   83fb03               | cmp                 ebx, 3
            //   72ea                 | jb                  0xffffffec
            //   eb05                 | jmp                 7

        $sequence_9 = { 53 57 8b3d???????? 56 ffd7 83c414 ff7510 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   83c414               | add                 esp, 0x14
            //   ff7510               | push                dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 425984
}