rule win_longwatch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.longwatch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.longwatch"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 8b5d10 8b0485a00b4300 56 8b7508 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8b0485a00b4300       | mov                 eax, dword ptr [eax*4 + 0x430ba0]
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_1 = { 68???????? e8???????? 83c404 6a00 ff15???????? 85c0 }
            // n = 6, score = 200
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8b0485a00b4300 f644082801 7406 8b440818 5d }
            // n = 5, score = 200
            //   8b0485a00b4300       | mov                 eax, dword ptr [eax*4 + 0x430ba0]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7406                 | je                  8
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]
            //   5d                   | pop                 ebp

        $sequence_3 = { 8be5 5d 8be3 5b c3 33c0 50 }
            // n = 7, score = 200
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   8be3                 | mov                 esp, ebx
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax

        $sequence_4 = { e9???????? 6a40 e9???????? 6a23 }
            // n = 4, score = 200
            //   e9????????           |                     
            //   6a40                 | push                0x40
            //   e9????????           |                     
            //   6a23                 | push                0x23

        $sequence_5 = { 85c0 0f8559010000 e8???????? c70021000000 e9???????? 894ddc c745e01c954200 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   0f8559010000         | jne                 0x15f
            //   e8????????           |                     
            //   c70021000000         | mov                 dword ptr [eax], 0x21
            //   e9????????           |                     
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   c745e01c954200       | mov                 dword ptr [ebp - 0x20], 0x42951c

        $sequence_6 = { 8b41e0 8b4004 c74408e090bb4200 8b41e0 8b5004 }
            // n = 5, score = 200
            //   8b41e0               | mov                 eax, dword ptr [ecx - 0x20]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c74408e090bb4200     | mov                 dword ptr [eax + ecx - 0x20], 0x42bb90
            //   8b41e0               | mov                 eax, dword ptr [ecx - 0x20]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]

        $sequence_7 = { 75de 33c0 85c0 0f94c0 c3 1bc0 }
            // n = 6, score = 200
            //   75de                 | jne                 0xffffffe0
            //   33c0                 | xor                 eax, eax
            //   85c0                 | test                eax, eax
            //   0f94c0               | sete                al
            //   c3                   | ret                 
            //   1bc0                 | sbb                 eax, eax

        $sequence_8 = { 0f8484000000 8b45f0 8b0485a00b4300 8a44022b }
            // n = 4, score = 200
            //   0f8484000000         | je                  0x8a
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b0485a00b4300       | mov                 eax, dword ptr [eax*4 + 0x430ba0]
            //   8a44022b             | mov                 al, byte ptr [edx + eax + 0x2b]

        $sequence_9 = { 8975f0 c745f4dc804200 8b7485bc 8d4601 8945b8 }
            // n = 5, score = 200
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c745f4dc804200       | mov                 dword ptr [ebp - 0xc], 0x4280dc
            //   8b7485bc             | mov                 esi, dword ptr [ebp + eax*4 - 0x44]
            //   8d4601               | lea                 eax, [esi + 1]
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax

    condition:
        7 of them and filesize < 647168
}