rule win_magniber_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.magniber."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magniber"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7420c00400000 eb0a 8b45fc c7400c00800000 8b4dfc c70100000000 }
            // n = 6, score = 400
            //   c7420c00400000       | mov                 dword ptr [edx + 0xc], 0x4000
            //   eb0a                 | jmp                 0xc
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   c7400c00800000       | mov                 dword ptr [eax + 0xc], 0x8000
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c70100000000         | mov                 dword ptr [ecx], 0

        $sequence_1 = { ff15???????? eb2e 837df803 7528 8d4da0 51 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   eb2e                 | jmp                 0x30
            //   837df803             | cmp                 dword ptr [ebp - 8], 3
            //   7528                 | jne                 0x2a
            //   8d4da0               | lea                 ecx, [ebp - 0x60]
            //   51                   | push                ecx

        $sequence_2 = { 52 8b4508 05e0020000 50 8b4d08 }
            // n = 5, score = 400
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   05e0020000           | add                 eax, 0x2e0
            //   50                   | push                eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_3 = { 66894dc2 ba31000000 668955c4 b835000000 668945c6 b920000000 }
            // n = 6, score = 400
            //   66894dc2             | mov                 word ptr [ebp - 0x3e], cx
            //   ba31000000           | mov                 edx, 0x31
            //   668955c4             | mov                 word ptr [ebp - 0x3c], dx
            //   b835000000           | mov                 eax, 0x35
            //   668945c6             | mov                 word ptr [ebp - 0x3a], ax
            //   b920000000           | mov                 ecx, 0x20

        $sequence_4 = { c785f8fdffff409b4000 c785fcfdffff489b4000 c78500feffff509b4000 c78504feffff589b4000 c78508feffff609b4000 c7850cfeffff689b4000 }
            // n = 6, score = 400
            //   c785f8fdffff409b4000     | mov    dword ptr [ebp - 0x208], 0x409b40
            //   c785fcfdffff489b4000     | mov    dword ptr [ebp - 0x204], 0x409b48
            //   c78500feffff509b4000     | mov    dword ptr [ebp - 0x200], 0x409b50
            //   c78504feffff589b4000     | mov    dword ptr [ebp - 0x1fc], 0x409b58
            //   c78508feffff609b4000     | mov    dword ptr [ebp - 0x1f8], 0x409b60
            //   c7850cfeffff689b4000     | mov    dword ptr [ebp - 0x1f4], 0x409b68

        $sequence_5 = { c785d8fbffff90964000 c785dcfbffff98964000 c785e0fbffffa0964000 c785e4fbffffac964000 c785e8fbffffb8964000 c785ecfbffffc0964000 }
            // n = 6, score = 400
            //   c785d8fbffff90964000     | mov    dword ptr [ebp - 0x428], 0x409690
            //   c785dcfbffff98964000     | mov    dword ptr [ebp - 0x424], 0x409698
            //   c785e0fbffffa0964000     | mov    dword ptr [ebp - 0x420], 0x4096a0
            //   c785e4fbffffac964000     | mov    dword ptr [ebp - 0x41c], 0x4096ac
            //   c785e8fbffffb8964000     | mov    dword ptr [ebp - 0x418], 0x4096b8
            //   c785ecfbffffc0964000     | mov    dword ptr [ebp - 0x414], 0x4096c0

        $sequence_6 = { 56 c745f000001000 c745c800000000 c745cc00000000 c745dc00000000 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   c745f000001000       | mov                 dword ptr [ebp - 0x10], 0x100000
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0

        $sequence_7 = { c78590fbfffff0954000 c78594fbfffff8954000 c78598fbffff00964000 c7859cfbffff0c964000 c785a0fbffff14964000 c785a4fbffff1c964000 }
            // n = 6, score = 400
            //   c78590fbfffff0954000     | mov    dword ptr [ebp - 0x470], 0x4095f0
            //   c78594fbfffff8954000     | mov    dword ptr [ebp - 0x46c], 0x4095f8
            //   c78598fbffff00964000     | mov    dword ptr [ebp - 0x468], 0x409600
            //   c7859cfbffff0c964000     | mov    dword ptr [ebp - 0x464], 0x40960c
            //   c785a0fbffff14964000     | mov    dword ptr [ebp - 0x460], 0x409614
            //   c785a4fbffff1c964000     | mov    dword ptr [ebp - 0x45c], 0x40961c

        $sequence_8 = { f8 a6 6e d89bcb299b94 }
            // n = 4, score = 100
            //   f8                   | jo                  0xffffffae
            //   a6                   | push                edx
            //   6e                   | clc                 
            //   d89bcb299b94         | cmpsb               byte ptr [esi], byte ptr es:[edi]

        $sequence_9 = { d331 4e4e54 70ac 52 }
            // n = 4, score = 100
            //   d331                 | sal                 dword ptr [ecx], cl
            //   4e4e54               | dec                 esi
            //   70ac                 | dec                 esi
            //   52                   | push                esp

        $sequence_10 = { 184026 e221 a1????????05eef081 e0f8 29aed0515fa6 }
            // n = 5, score = 100
            //   184026               | loop                0x23
            //   e221                 | loopne              0xfffffffa
            //   a1????????05eef081     |     
            //   e0f8                 | sub                 dword ptr [esi - 0x59a0ae30], ebp
            //   29aed0515fa6         | lea                 ecx, [edi + 0xe]

        $sequence_11 = { 18cb 52 fc 285f44 c1c70d 11fb }
            // n = 6, score = 100
            //   18cb                 | mov                 dh, 0x36
            //   52                   | loopne              0xfffffffa
            //   fc                   | sub                 dword ptr [esi - 0x59a0ae30], ebp
            //   285f44               | lea                 ecx, [edi + 0xe]
            //   c1c70d               | jg                  0x4e
            //   11fb                 | sbb                 bl, cl

        $sequence_12 = { 5a b3b1 3e6c 21746c2e 4834b0 184026 e221 }
            // n = 7, score = 100
            //   5a                   | clc                 
            //   b3b1                 | cmpsb               byte ptr [esi], byte ptr es:[edi]
            //   3e6c                 | outsb               dx, byte ptr [esi]
            //   21746c2e             | fcomp               dword ptr [ebx - 0x6b64d635]
            //   4834b0               | pop                 edx
            //   184026               | mov                 bl, 0xb1
            //   e221                 | insb                byte ptr es:[edi], dx

        $sequence_13 = { f76e9f 32d8 2d7a350e78 95 }
            // n = 4, score = 100
            //   f76e9f               | and                 dword ptr [esp + ebp*2 + 0x2e], esi
            //   32d8                 | dec                 eax
            //   2d7a350e78           | xor                 al, 0xb0
            //   95                   | sbb                 byte ptr [eax + 0x26], al

        $sequence_14 = { 29aed0515fa6 8d4f0e 7f4c c82cd1c6 1a32 b636 }
            // n = 6, score = 100
            //   29aed0515fa6         | jo                  0xffffffae
            //   8d4f0e               | push                edx
            //   7f4c                 | sub                 dword ptr [esi - 0x59a0ae30], ebp
            //   c82cd1c6             | lea                 ecx, [edi + 0xe]
            //   1a32                 | jg                  0x51
            //   b636                 | enter               -0x2ed4, -0x3a

        $sequence_15 = { e8???????? 32cb 5a b3b1 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   32cb                 | sbb                 byte ptr [eax + 0x26], al
            //   5a                   | loop                0x29
            //   b3b1                 | loopne              2

    condition:
        7 of them and filesize < 117760
}