rule win_makadocs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.makadocs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makadocs"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7468 8b33 8b4ef0 8b01 8b5010 83ee10 ffd2 }
            // n = 7, score = 100
            //   7468                 | je                  0x6a
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   8b4ef0               | mov                 ecx, dword ptr [esi - 0x10]
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   83ee10               | sub                 esi, 0x10
            //   ffd2                 | call                edx

        $sequence_1 = { 750a 6805400080 e8???????? 8b1b 56 53 e8???????? }
            // n = 7, score = 100
            //   750a                 | jne                 0xc
            //   6805400080           | push                0x80004005
            //   e8????????           |                     
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   56                   | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_2 = { ffd7 8be8 55 6a00 ff15???????? 8bf0 85f6 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   8be8                 | mov                 ebp, eax
            //   55                   | push                ebp
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_3 = { 8b1b 6a0a 8d442434 50 53 e8???????? 83c410 }
            // n = 7, score = 100
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   6a0a                 | push                0xa
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_4 = { 8d410c 55 e8???????? 84c0 }
            // n = 4, score = 100
            //   8d410c               | lea                 eax, [ecx + 0xc]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_5 = { c68424b400000016 e8???????? 83c410 c68424a400000017 8b08 8b41f4 51 }
            // n = 7, score = 100
            //   c68424b400000016     | mov                 byte ptr [esp + 0xb4], 0x16
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   c68424a400000017     | mov                 byte ptr [esp + 0xa4], 0x17
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b41f4               | mov                 eax, dword ptr [ecx - 0xc]
            //   51                   | push                ecx

        $sequence_6 = { 59 8b7508 8d34f5c8514200 391e 7404 8bc7 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d34f5c8514200       | lea                 esi, [esi*8 + 0x4251c8]
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   7404                 | je                  6
            //   8bc7                 | mov                 eax, edi

        $sequence_7 = { ffd0 8b442438 53 8d4c2434 51 8d542448 52 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   53                   | push                ebx
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   51                   | push                ecx
            //   8d542448             | lea                 edx, [esp + 0x48]
            //   52                   | push                edx

        $sequence_8 = { b9???????? ffd0 83c010 894678 c644241c04 8b15???????? 8b420c }
            // n = 7, score = 100
            //   b9????????           |                     
            //   ffd0                 | call                eax
            //   83c010               | add                 eax, 0x10
            //   894678               | mov                 dword ptr [esi + 0x78], eax
            //   c644241c04           | mov                 byte ptr [esp + 0x1c], 4
            //   8b15????????         |                     
            //   8b420c               | mov                 eax, dword ptr [edx + 0xc]

        $sequence_9 = { e8???????? 83c40c 8d757c 85c0 7504 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d757c               | lea                 esi, [ebp + 0x7c]
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6

    condition:
        7 of them and filesize < 344064
}