rule win_manjusaka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.manjusaka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.manjusaka"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b460c f7d0 2346f0 0b4608 8946f0 e9???????? 48897ef0 }
            // n = 7, score = 100
            //   8b460c               | mov                 dword ptr [esp + 0x60], eax
            //   f7d0                 | dec                 eax
            //   2346f0               | mov                 eax, dword ptr [ebp - 0x58]
            //   0b4608               | dec                 eax
            //   8946f0               | test                eax, eax
            //   e9????????           |                     
            //   48897ef0             | je                  0x190f

        $sequence_1 = { 894c2420 458bc6 498bcf 8945ef ba4d000000 e8???????? 8b7d7f }
            // n = 7, score = 100
            //   894c2420             | test                al, al
            //   458bc6               | test                al, al
            //   498bcf               | js                  0x8b0
            //   8945ef               | movzx               edx, al
            //   ba4d000000           | mov                 esi, 1
            //   e8????????           |                     
            //   8b7d7f               | dec                 esp

        $sequence_2 = { b909000000 f348a5 498b8548020000 48898348020000 410f108518020000 410f108d28020000 410f109538020000 }
            // n = 7, score = 100
            //   b909000000           | dec                 eax
            //   f348a5               | mov                 ecx, dword ptr [ebp - 0x59]
            //   498b8548020000       | sub                 edx, dword ptr [ecx]
            //   48898348020000       | dec                 eax
            //   410f108518020000     | mov                 ecx, dword ptr [ecx]
            //   410f108d28020000     | dec                 eax
            //   410f109538020000     | mov                 dword ptr [esp + 0x20], ecx

        $sequence_3 = { 7f19 488b4608 6646391c60 7c0e 66412bd7 66015316 0fb77b16 }
            // n = 7, score = 100
            //   7f19                 | je                  0x2af
            //   488b4608             | inc                 esp
            //   6646391c60           | mov                 ecx, dword ptr [ebx + 0x60]
            //   7c0e                 | inc                 ebp
            //   66412bd7             | xor                 eax, eax
            //   66015316             | and                 dword ptr [esp + 0x20], 0
            //   0fb77b16             | dec                 eax

        $sequence_4 = { 4c8b7910 488bcb 4c8b6a18 48895c2478 e8???????? ff4f44 448bc0 }
            // n = 7, score = 100
            //   4c8b7910             | mov                 dword ptr [esp + 0x30], ecx
            //   488bcb               | mov                 edx, 0x19
            //   4c8b6a18             | dec                 eax
            //   48895c2478           | mov                 dword ptr [esp + 0x28], edi
            //   e8????????           |                     
            //   ff4f44               | dec                 eax
            //   448bc0               | mov                 dword ptr [esp + 0x20], edi

        $sequence_5 = { 834e0420 41834e2840 397b30 7509 488b03 40387861 7405 }
            // n = 7, score = 100
            //   834e0420             | dec                 eax
            //   41834e2840           | mov                 ecx, edi
            //   397b30               | jmp                 0x405
            //   7509                 | mov                 ecx, 1
            //   488b03               | jne                 0x3ca
            //   40387861             | jmp                 0x347
            //   7405                 | dec                 eax

        $sequence_6 = { eb07 488d3dd6030b00 488d1564270b00 488bcf e8???????? 85c0 488d155f270b00 }
            // n = 7, score = 100
            //   eb07                 | dec                 esp
            //   488d3dd6030b00       | lea                 esp, [esp + 0x58]
            //   488d1564270b00       | inc                 ecx
            //   488bcf               | mov                 eax, 0xb8
            //   e8????????           |                     
            //   85c0                 | dec                 esp
            //   488d155f270b00       | mov                 ecx, esp

        $sequence_7 = { e8???????? 0f1005???????? 0f1100 0f1005???????? 0f114010 0fb70d???????? 66894820 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f1005????????       |                     
            //   0f1100               | mov                 eax, dword ptr [esi + 0x88]
            //   0f1005????????       |                     
            //   0f114010             | mov                 word ptr [eax + ecx*8 - 0x16], dx
            //   0fb70d????????       |                     
            //   66894820             | dec                 esp

        $sequence_8 = { e9???????? 660f74d1 660fd7fa 85ff 7510 4c01c3 4883c310 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   660f74d1             | inc                 esp
            //   660fd7fa             | lea                 eax, [edi + 1]
            //   85ff                 | dec                 eax
            //   7510                 | mov                 ecx, esi
            //   4c01c3               | dec                 eax
            //   4883c310             | lea                 edx, [0xd36db]

        $sequence_9 = { e9???????? 6641baaecc e9???????? 6641bafefe e9???????? 6641bafffe e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6641baaecc           | dec                 eax
            //   e9????????           |                     
            //   6641bafefe           | lea                 edx, [esp + 0x30]
            //   e9????????           |                     
            //   6641bafffe           | jmp                 0x95e
            //   e9????????           |                     

    condition:
        7 of them and filesize < 4772864
}