rule win_mapiget_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mapiget."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mapiget"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 8b750c b900010000 8dbdf0f9ffff 8965f0 f3ab b980000000 }
            // n = 7, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   b900010000           | mov                 ecx, 0x100
            //   8dbdf0f9ffff         | lea                 edi, [ebp - 0x610]
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   b980000000           | mov                 ecx, 0x80

        $sequence_1 = { 8dbdf0feffff f3ab 8b750c b900010000 }
            // n = 4, score = 100
            //   8dbdf0feffff         | lea                 edi, [ebp - 0x110]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   b900010000           | mov                 ecx, 0x100

        $sequence_2 = { 0108 c20400 8bc1 c700???????? c20400 }
            // n = 5, score = 100
            //   0108                 | add                 dword ptr [eax], ecx
            //   c20400               | ret                 4
            //   8bc1                 | mov                 eax, ecx
            //   c700????????         |                     
            //   c20400               | ret                 4

        $sequence_3 = { 6a40 50 e8???????? 83c40c 85c0 0f84f8010000 }
            // n = 6, score = 100
            //   6a40                 | push                0x40
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   0f84f8010000         | je                  0x1fe

        $sequence_4 = { 6689bc45eef9ffff 8d95f0fdffff 8d85f0f9ffff 52 50 e8???????? 83c408 }
            // n = 7, score = 100
            //   6689bc45eef9ffff     | mov                 word ptr [ebp + eax*2 - 0x612], di
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   8d85f0f9ffff         | lea                 eax, [ebp - 0x610]
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_5 = { 83cdff 56 83fb02 57 }
            // n = 4, score = 100
            //   83cdff               | or                  ebp, 0xffffffff
            //   56                   | push                esi
            //   83fb02               | cmp                 ebx, 2
            //   57                   | push                edi

        $sequence_6 = { 8d8c2430020000 53 51 e8???????? }
            // n = 4, score = 100
            //   8d8c2430020000       | lea                 ecx, [esp + 0x230]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_7 = { 81ec20040000 53 57 33db b97f000000 33c0 8d7c242a }
            // n = 7, score = 100
            //   81ec20040000         | sub                 esp, 0x420
            //   53                   | push                ebx
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   b97f000000           | mov                 ecx, 0x7f
            //   33c0                 | xor                 eax, eax
            //   8d7c242a             | lea                 edi, [esp + 0x2a]

        $sequence_8 = { c706???????? 8b4624 8365fc00 85c0 7612 fe88e0134100 }
            // n = 6, score = 100
            //   c706????????         |                     
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   85c0                 | test                eax, eax
            //   7612                 | jbe                 0x14
            //   fe88e0134100         | dec                 byte ptr [eax + 0x4113e0]

        $sequence_9 = { c3 660dffff c3 56 8bf1 e8???????? }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   660dffff             | or                  ax, 0xffff
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 163840
}