rule win_meow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.meow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.meow"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645c14c c645c24b c645c36d c645c44b c645c572 c645c64b c645c74b }
            // n = 7, score = 100
            //   c645c14c             | mov                 byte ptr [ebp - 0x3f], 0x4c
            //   c645c24b             | mov                 byte ptr [ebp - 0x3e], 0x4b
            //   c645c36d             | mov                 byte ptr [ebp - 0x3d], 0x6d
            //   c645c44b             | mov                 byte ptr [ebp - 0x3c], 0x4b
            //   c645c572             | mov                 byte ptr [ebp - 0x3b], 0x72
            //   c645c64b             | mov                 byte ptr [ebp - 0x3a], 0x4b
            //   c645c74b             | mov                 byte ptr [ebp - 0x39], 0x4b

        $sequence_1 = { c68525fdffff41 c68526fdffff41 8a85fdfcffff 389dfcfcffff 7539 33ff 8d777f }
            // n = 7, score = 100
            //   c68525fdffff41       | mov                 byte ptr [ebp - 0x2db], 0x41
            //   c68526fdffff41       | mov                 byte ptr [ebp - 0x2da], 0x41
            //   8a85fdfcffff         | mov                 al, byte ptr [ebp - 0x303]
            //   389dfcfcffff         | cmp                 byte ptr [ebp - 0x304], bl
            //   7539                 | jne                 0x3b
            //   33ff                 | xor                 edi, edi
            //   8d777f               | lea                 esi, [edi + 0x7f]

        $sequence_2 = { c685d9f8ffff71 c685daf8ffff11 c685dbf8ffff6a c685dcf8ffff11 c685ddf8ffff11 c685def8ffff11 8a85d1f8ffff }
            // n = 7, score = 100
            //   c685d9f8ffff71       | mov                 byte ptr [ebp - 0x727], 0x71
            //   c685daf8ffff11       | mov                 byte ptr [ebp - 0x726], 0x11
            //   c685dbf8ffff6a       | mov                 byte ptr [ebp - 0x725], 0x6a
            //   c685dcf8ffff11       | mov                 byte ptr [ebp - 0x724], 0x11
            //   c685ddf8ffff11       | mov                 byte ptr [ebp - 0x723], 0x11
            //   c685def8ffff11       | mov                 byte ptr [ebp - 0x722], 0x11
            //   8a85d1f8ffff         | mov                 al, byte ptr [ebp - 0x72f]

        $sequence_3 = { c68570fcffff05 c68571fcffff0a c68572fcffff05 c68573fcffff27 c68574fcffff05 c68575fcffff05 c68576fcffff05 }
            // n = 7, score = 100
            //   c68570fcffff05       | mov                 byte ptr [ebp - 0x390], 5
            //   c68571fcffff0a       | mov                 byte ptr [ebp - 0x38f], 0xa
            //   c68572fcffff05       | mov                 byte ptr [ebp - 0x38e], 5
            //   c68573fcffff27       | mov                 byte ptr [ebp - 0x38d], 0x27
            //   c68574fcffff05       | mov                 byte ptr [ebp - 0x38c], 5
            //   c68575fcffff05       | mov                 byte ptr [ebp - 0x38b], 5
            //   c68576fcffff05       | mov                 byte ptr [ebp - 0x38a], 5

        $sequence_4 = { 7209 8b4210 03c6 3bf8 720b 41 663bcb }
            // n = 7, score = 100
            //   7209                 | jb                  0xb
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   03c6                 | add                 eax, esi
            //   3bf8                 | cmp                 edi, eax
            //   720b                 | jb                  0xd
            //   41                   | inc                 ecx
            //   663bcb               | cmp                 cx, bx

        $sequence_5 = { c6858afbffff4d c6858bfbffff2f c6858cfbffff4d c6858dfbffff2b c6858efbffff4d c6858ffbffff43 c68590fbffff4d }
            // n = 7, score = 100
            //   c6858afbffff4d       | mov                 byte ptr [ebp - 0x476], 0x4d
            //   c6858bfbffff2f       | mov                 byte ptr [ebp - 0x475], 0x2f
            //   c6858cfbffff4d       | mov                 byte ptr [ebp - 0x474], 0x4d
            //   c6858dfbffff2b       | mov                 byte ptr [ebp - 0x473], 0x2b
            //   c6858efbffff4d       | mov                 byte ptr [ebp - 0x472], 0x4d
            //   c6858ffbffff43       | mov                 byte ptr [ebp - 0x471], 0x43
            //   c68590fbffff4d       | mov                 byte ptr [ebp - 0x470], 0x4d

        $sequence_6 = { 83c001 0f852e010000 8b442410 40 89442410 8b442410 2503000080 }
            // n = 7, score = 100
            //   83c001               | add                 eax, 1
            //   0f852e010000         | jne                 0x134
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   40                   | inc                 eax
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   2503000080           | and                 eax, 0x80000003

        $sequence_7 = { 00942103007e21 0300 6a21 0300 5c 2103 005021 }
            // n = 7, score = 100
            //   00942103007e21       | add                 byte ptr [ecx + 0x217e0003], dl
            //   0300                 | add                 eax, dword ptr [eax]
            //   6a21                 | push                0x21
            //   0300                 | add                 eax, dword ptr [eax]
            //   5c                   | pop                 esp
            //   2103                 | and                 dword ptr [ebx], eax
            //   005021               | add                 byte ptr [eax + 0x21], dl

        $sequence_8 = { c685b1fcffff56 c685b2fcffff56 8a85a9fcffff e8???????? 8985e8f5ffff 8d8d9cfcffff c6859cfcffff00 }
            // n = 7, score = 100
            //   c685b1fcffff56       | mov                 byte ptr [ebp - 0x34f], 0x56
            //   c685b2fcffff56       | mov                 byte ptr [ebp - 0x34e], 0x56
            //   8a85a9fcffff         | mov                 al, byte ptr [ebp - 0x357]
            //   e8????????           |                     
            //   8985e8f5ffff         | mov                 dword ptr [ebp - 0xa18], eax
            //   8d8d9cfcffff         | lea                 ecx, [ebp - 0x364]
            //   c6859cfcffff00       | mov                 byte ptr [ebp - 0x364], 0

        $sequence_9 = { 0f845489ffff e9???????? e9???????? 55 8bec ff7508 }
            // n = 6, score = 100
            //   0f845489ffff         | je                  0xffff895a
            //   e9????????           |                     
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 492544
}