rule win_mim221_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mim221."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mim221"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89442418 53 57 4883ec38 498bc1 498bd8 4c8bd2 }
            // n = 7, score = 100
            //   4c89442418           | dec                 eax
            //   53                   | cmp                 eax, ebx
            //   57                   | dec                 eax
            //   4883ec38             | mov                 dword ptr [esp + 0x20], eax
            //   498bc1               | je                  0x1540
            //   498bd8               | inc                 esp
            //   4c8bd2               | movzx               ecx, word ptr [edi + 2]

        $sequence_1 = { 56 57 4154 4c8bdc 4883ec38 488b05???????? 4c8d25f5b80000 }
            // n = 7, score = 100
            //   56                   | mov                 dword ptr [esp + 0x5d8], ebx
            //   57                   | mov                 dword ptr [esp + 0x5dc], ebp
            //   4154                 | xor                 edx, edx
            //   4c8bdc               | dec                 esp
            //   4883ec38             | mov                 eax, esi
            //   488b05????????       |                     
            //   4c8d25f5b80000       | mov                 byte ptr [esp + 0x1b0], 0x48

        $sequence_2 = { ff15???????? 85c0 0f84e5000000 c7442428ff000000 488d442470 4889442420 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | mov                 word ptr [esp + 0x14e], bx
            //   0f84e5000000         | mov                 word ptr [esp + 0x150], bx
            //   c7442428ff000000     | mov                 word ptr [esp + 0x152], bx
            //   488d442470           | mov                 word ptr [esp + 0x154], bx
            //   4889442420           | mov                 word ptr [esp + 0x156], 0x50

        $sequence_3 = { 6689942478020000 66b92500 66898c247a020000 668984247c020000 668994247e020000 66c78424800200003b00 6689942482020000 }
            // n = 7, score = 100
            //   6689942478020000     | mov                 eax, 6
            //   66b92500             | dec                 esp
            //   66898c247a020000     | lea                 ecx, [0x13ff2]
            //   668984247c020000     | nop                 
            //   668994247e020000     | dec                 esp
            //   66c78424800200003b00     | cmp    dword ptr [eax - 0x10], ecx
            //   6689942482020000     | je                  0x186c

        $sequence_4 = { 57 4154 4155 4156 4157 4881ec80010000 48c7842428010000feffffff }
            // n = 7, score = 100
            //   57                   | xor                 edx, edx
            //   4154                 | mov                 dword ptr [esp + 0x680], 0x47ba
            //   4155                 | mov                 dword ptr [esp + 0x688], 0x10
            //   4156                 | inc                 esp
            //   4157                 | mov                 dword ptr [esp + 0x6ac], ebp
            //   4881ec80010000       | dec                 eax
            //   48c7842428010000feffffff     | mov    dword ptr [esp + 0x690], eax

        $sequence_5 = { 4883f905 72eb eb1d 488d842440050000 3910 7711 4883c101 }
            // n = 7, score = 100
            //   4883f905             | je                  0x900
            //   72eb                 | cmp                 ebx, 3
            //   eb1d                 | jne                 0xa04
            //   488d842440050000     | cmp                 ebx, 1
            //   3910                 | je                  0x8f7
            //   7711                 | mov                 word ptr [esp + 0x20], 0x75
            //   4883c101             | mov                 word ptr [esp + 0x22], 0x6e

        $sequence_6 = { 66c74424666f00 66c74424686400 66c744246a6500 66c744246c5300 668944246e 66c74424707200 66c74424726900 }
            // n = 7, score = 100
            //   66c74424666f00       | mov                 edx, ebp
            //   66c74424686400       | dec                 eax
            //   66c744246a6500       | mov                 dword ptr [esp + 0x30], eax
            //   66c744246c5300       | dec                 eax
            //   668944246e           | test                eax, eax
            //   66c74424707200       | inc                 esp
            //   66c74424726900       | lea                 ebp, [ebp - 0x10]

        $sequence_7 = { c3 4533c0 488d15be910100 498bc8 66666690 }
            // n = 5, score = 100
            //   c3                   | mov                 word ptr [esp + 0x7e], ax
            //   4533c0               | mov                 word ptr [esp + 0x76], 0x61
            //   488d15be910100       | mov                 word ptr [esp + 0x78], 0x74
            //   498bc8               | mov                 word ptr [esp + 0x7a], bx
            //   66666690             | mov                 word ptr [esp + 0x7e], 0x6e

        $sequence_8 = { 0f8c6b010000 8bc7 488d153b7b0100 412bc4 3bc5 0f8260ffffff e9???????? }
            // n = 7, score = 100
            //   0f8c6b010000         | mov                 word ptr [esp + 0x2a], 0x76
            //   8bc7                 | mov                 word ptr [esp + 0x2c], 0x2e
            //   488d153b7b0100       | mov                 word ptr [esp + 0x2e], 0x64
            //   412bc4               | mov                 word ptr [esp + 0x30], 0x6c
            //   3bc5                 | mov                 word ptr [esp + 0x28], 0x32
            //   0f8260ffffff         | mov                 word ptr [esp + 0x2a], 0x38
            //   e9????????           |                     

        $sequence_9 = { 488bf8 483bc3 7504 33c0 eb58 498d5708 895c2430 }
            // n = 7, score = 100
            //   488bf8               | mov                 byte ptr [esp + 0x65], 0x69
            //   483bc3               | mov                 byte ptr [esp + 0x66], 0x76
            //   7504                 | mov                 byte ptr [esp + 0x67], 0x69
            //   33c0                 | mov                 byte ptr [esp + 0x68], 0x6c
            //   eb58                 | mov                 byte ptr [esp + 0x69], 0x65
            //   498d5708             | mov                 byte ptr [esp + 0x6a], 0x67
            //   895c2430             | mov                 byte ptr [esp + 0x65], 0x74

    condition:
        7 of them and filesize < 471040
}