rule win_miragefox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.miragefox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.miragefox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 83c424 8d85f877ffff b9???????? 8975fc }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24
            //   8d85f877ffff         | lea                 eax, [ebp - 0x8808]
            //   b9????????           |                     
            //   8975fc               | mov                 dword ptr [ebp - 4], esi

        $sequence_1 = { ffd6 ff750c 8bf0 57 }
            // n = 4, score = 100
            //   ffd6                 | call                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8bf0                 | mov                 esi, eax
            //   57                   | push                edi

        $sequence_2 = { 68???????? 50 e8???????? 8bf8 33db 59 3bfb }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   33db                 | xor                 ebx, ebx
            //   59                   | pop                 ecx
            //   3bfb                 | cmp                 edi, ebx

        $sequence_3 = { 89b5087cffff 50 e8???????? 03bd187cffff e9???????? }
            // n = 5, score = 100
            //   89b5087cffff         | mov                 dword ptr [ebp - 0x83f8], esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   03bd187cffff         | add                 edi, dword ptr [ebp - 0x83e8]
            //   e9????????           |                     

        $sequence_4 = { c1f905 83e01f 8b0c8d20f52a00 8d04c0 f644810401 741d }
            // n = 6, score = 100
            //   c1f905               | sar                 ecx, 5
            //   83e01f               | and                 eax, 0x1f
            //   8b0c8d20f52a00       | mov                 ecx, dword ptr [ecx*4 + 0x2af520]
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   f644810401           | test                byte ptr [ecx + eax*4 + 4], 1
            //   741d                 | je                  0x1f

        $sequence_5 = { 33c0 85db 7e08 000438 40 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   85db                 | test                ebx, ebx
            //   7e08                 | jle                 0xa
            //   000438               | add                 byte ptr [eax + edi], al
            //   40                   | inc                 eax

        $sequence_6 = { 8945e8 53 8d85a873ffff 56 50 e8???????? 53 }
            // n = 7, score = 100
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   53                   | push                ebx
            //   8d85a873ffff         | lea                 eax, [ebp - 0x8c58]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_7 = { 8b45f0 6808880000 2b45ec 53 }
            // n = 4, score = 100
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   6808880000           | push                0x8808
            //   2b45ec               | sub                 eax, dword ptr [ebp - 0x14]
            //   53                   | push                ebx

        $sequence_8 = { 83f8ff 8945fc 0f84e1000000 bf14410000 8d85d4beffff 57 53 }
            // n = 7, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0f84e1000000         | je                  0xe7
            //   bf14410000           | mov                 edi, 0x4114
            //   8d85d4beffff         | lea                 eax, [ebp - 0x412c]
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_9 = { 2900 55 8bec 81ec48030000 53 }
            // n = 5, score = 100
            //   2900                 | sub                 dword ptr [eax], eax
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec48030000         | sub                 esp, 0x348
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 286720
}