rule win_moker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.moker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.moker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0302 8945d4 8b4dd4 83c102 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   83c102               | add                 ecx, 2

        $sequence_1 = { 0302 8945e8 8b4df8 8b55fc }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_2 = { 0100 83c414 85c0 7502 eb0a }
            // n = 5, score = 200
            //   0100                 | add                 dword ptr [eax], eax
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb0a                 | jmp                 0xc

        $sequence_3 = { 0301 8945e0 e8???????? 8b55e8 }
            // n = 4, score = 200
            //   0301                 | add                 eax, dword ptr [ecx]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   e8????????           |                     
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_4 = { 0302 8945dc 8b45dc 83c002 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   83c002               | add                 eax, 2

        $sequence_5 = { 0302 50 e8???????? 83c404 3b450c 750b 8b4df0 }
            // n = 7, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3b450c               | cmp                 eax, dword ptr [ebp + 0xc]
            //   750b                 | jne                 0xd
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]

        $sequence_6 = { 6a00 6a04 8d9550ffffff 52 }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   8d9550ffffff         | lea                 edx, [ebp - 0xb0]
            //   52                   | push                edx

        $sequence_7 = { 0302 8945e8 eb09 8b45e8 }
            // n = 4, score = 200
            //   0302                 | add                 eax, dword ptr [edx]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   eb09                 | jmp                 0xb
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

        $sequence_8 = { 80fa20 720e 80fa7a 7709 feca 80fa1f 7502 }
            // n = 7, score = 100
            //   80fa20               | cmp                 dl, 0x20
            //   720e                 | jb                  0x10
            //   80fa7a               | cmp                 dl, 0x7a
            //   7709                 | ja                  0xb
            //   feca                 | dec                 dl
            //   80fa1f               | cmp                 dl, 0x1f
            //   7502                 | jne                 4

        $sequence_9 = { 803aed 0f84cc000000 803af8 7453 803aec 0f848e000000 803ae4 }
            // n = 7, score = 100
            //   803aed               | cmp                 byte ptr [edx], 0xed
            //   0f84cc000000         | je                  0xd2
            //   803af8               | cmp                 byte ptr [edx], 0xf8
            //   7453                 | je                  0x55
            //   803aec               | cmp                 byte ptr [edx], 0xec
            //   0f848e000000         | je                  0x94
            //   803ae4               | cmp                 byte ptr [edx], 0xe4

        $sequence_10 = { 6a02 6804000008 68000000c0 ff7508 }
            // n = 4, score = 100
            //   6a02                 | push                2
            //   6804000008           | push                0x8000004
            //   68000000c0           | push                0xc0000000
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_11 = { 85c0 0f852f020000 6a01 ec }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f852f020000         | jne                 0x235
            //   6a01                 | push                1
            //   ec                   | in                  al, dx

        $sequence_12 = { 42 41 ebec 803900 7509 }
            // n = 5, score = 100
            //   42                   | inc                 edx
            //   41                   | inc                 ecx
            //   ebec                 | jmp                 0xffffffee
            //   803900               | cmp                 byte ptr [ecx], 0
            //   7509                 | jne                 0xb

        $sequence_13 = { 740d 83c002 50 ff7508 }
            // n = 4, score = 100
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_14 = { ed 2e5c 85c0 740b 40 50 }
            // n = 6, score = 100
            //   ed                   | in                  eax, dx
            //   2e5c                 | pop                 esp
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_15 = { 83ec0c 51 52 8b450c 85c0 7451 }
            // n = 6, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   7451                 | je                  0x53

    condition:
        7 of them and filesize < 1761280
}