rule win_mortis_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mortis."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mortis"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75e5 bf08000000 8b0c1f c1e102 81f900100000 7212 8b50fc }
            // n = 7, score = 100
            //   75e5                 | jne                 0xffffffe7
            //   bf08000000           | mov                 edi, 8
            //   8b0c1f               | mov                 ecx, dword ptr [edi + ebx]
            //   c1e102               | shl                 ecx, 2
            //   81f900100000         | cmp                 ecx, 0x1000
            //   7212                 | jb                  0x14
            //   8b50fc               | mov                 edx, dword ptr [eax - 4]

        $sequence_1 = { 8b4690 8b4004 c7443090ecc24300 8b4690 8b4804 8d41e8 8944318c }
            // n = 7, score = 100
            //   8b4690               | mov                 eax, dword ptr [esi - 0x70]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   c7443090ecc24300     | mov                 dword ptr [eax + esi - 0x70], 0x43c2ec
            //   8b4690               | mov                 eax, dword ptr [esi - 0x70]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41e8               | lea                 eax, [ecx - 0x18]
            //   8944318c             | mov                 dword ptr [ecx + esi - 0x74], eax

        $sequence_2 = { 2bc2 83c0fc 83f81f 0f872c050000 51 52 e8???????? }
            // n = 7, score = 100
            //   2bc2                 | sub                 eax, edx
            //   83c0fc               | add                 eax, -4
            //   83f81f               | cmp                 eax, 0x1f
            //   0f872c050000         | ja                  0x532
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_3 = { c1e908 6a0a 8854072a 8b049d201f4400 884c072b 8b049d201f4400 59 }
            // n = 7, score = 100
            //   c1e908               | shr                 ecx, 8
            //   6a0a                 | push                0xa
            //   8854072a             | mov                 byte ptr [edi + eax + 0x2a], dl
            //   8b049d201f4400       | mov                 eax, dword ptr [ebx*4 + 0x441f20]
            //   884c072b             | mov                 byte ptr [edi + eax + 0x2b], cl
            //   8b049d201f4400       | mov                 eax, dword ptr [ebx*4 + 0x441f20]
            //   59                   | pop                 ecx

        $sequence_4 = { 740f 83f8fe 740a 6bfa38 033c8d201f4400 f6472d01 7418 }
            // n = 7, score = 100
            //   740f                 | je                  0x11
            //   83f8fe               | cmp                 eax, -2
            //   740a                 | je                  0xc
            //   6bfa38               | imul                edi, edx, 0x38
            //   033c8d201f4400       | add                 edi, dword ptr [ecx*4 + 0x441f20]
            //   f6472d01             | test                byte ptr [edi + 0x2d], 1
            //   7418                 | je                  0x1a

        $sequence_5 = { e8???????? 8d8564ffffff 50 e8???????? 83c40c e8???????? 0f57c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8564ffffff         | lea                 eax, [ebp - 0x9c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e8????????           |                     
            //   0f57c0               | xorps               xmm0, xmm0

        $sequence_6 = { 0f8238feffff 8b55d4 41 8bc2 81f900100000 7210 8b50fc }
            // n = 7, score = 100
            //   0f8238feffff         | jb                  0xfffffe3e
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   41                   | inc                 ecx
            //   8bc2                 | mov                 eax, edx
            //   81f900100000         | cmp                 ecx, 0x1000
            //   7210                 | jb                  0x12
            //   8b50fc               | mov                 edx, dword ptr [eax - 4]

        $sequence_7 = { 2bc1 85c9 0f84c7000000 0fbe0e 40 03c2 894de8 }
            // n = 7, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   85c9                 | test                ecx, ecx
            //   0f84c7000000         | je                  0xcd
            //   0fbe0e               | movsx               ecx, byte ptr [esi]
            //   40                   | inc                 eax
            //   03c2                 | add                 eax, edx
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx

        $sequence_8 = { e8???????? c645fc10 0f57c0 6a04 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   c645fc10             | mov                 byte ptr [ebp - 4], 0x10
            //   0f57c0               | xorps               xmm0, xmm0
            //   6a04                 | push                4

        $sequence_9 = { eb34 b916000000 3bf1 0f42f1 8d4e01 }
            // n = 5, score = 100
            //   eb34                 | jmp                 0x36
            //   b916000000           | mov                 ecx, 0x16
            //   3bf1                 | cmp                 esi, ecx
            //   0f42f1               | cmovb               esi, ecx
            //   8d4e01               | lea                 ecx, [esi + 1]

    condition:
        7 of them and filesize < 577536
}