rule win_mydogs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mydogs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mydogs"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5d94 8b75cc 8b7dc8 85db }
            // n = 4, score = 200
            //   8b5d94               | mov                 ebx, dword ptr [ebp - 0x6c]
            //   8b75cc               | mov                 esi, dword ptr [ebp - 0x34]
            //   8b7dc8               | mov                 edi, dword ptr [ebp - 0x38]
            //   85db                 | test                ebx, ebx

        $sequence_1 = { 8a01 88040a 41 84c0 75f6 3885c8feffff 0f84f6060000 }
            // n = 7, score = 200
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   41                   | inc                 ecx
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   3885c8feffff         | cmp                 byte ptr [ebp - 0x138], al
            //   0f84f6060000         | je                  0x6fc

        $sequence_2 = { 66c745d90000 c645db00 c645dc00 c745f500000000 66c745f90000 c645fb00 c6459c00 }
            // n = 7, score = 200
            //   66c745d90000         | mov                 word ptr [ebp - 0x27], 0
            //   c645db00             | mov                 byte ptr [ebp - 0x25], 0
            //   c645dc00             | mov                 byte ptr [ebp - 0x24], 0
            //   c745f500000000       | mov                 dword ptr [ebp - 0xb], 0
            //   66c745f90000         | mov                 word ptr [ebp - 7], 0
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0
            //   c6459c00             | mov                 byte ptr [ebp - 0x64], 0

        $sequence_3 = { 6a00 8bcf 81e900803ed5 8bc6 6880969800 1ddeb19d01 50 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8bcf                 | mov                 ecx, edi
            //   81e900803ed5         | sub                 ecx, 0xd53e8000
            //   8bc6                 | mov                 eax, esi
            //   6880969800           | push                0x989680
            //   1ddeb19d01           | sbb                 eax, 0x19db1de
            //   50                   | push                eax

        $sequence_4 = { 72d7 61 9d 0fb605???????? f30f7e05???????? 8845a4 }
            // n = 6, score = 200
            //   72d7                 | jb                  0xffffffd9
            //   61                   | popal               
            //   9d                   | popfd               
            //   0fb605????????       |                     
            //   f30f7e05????????     |                     
            //   8845a4               | mov                 byte ptr [ebp - 0x5c], al

        $sequence_5 = { 40 8945e4 8bc3 99 83e203 33c9 }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8bc3                 | mov                 eax, ebx
            //   99                   | cdq                 
            //   83e203               | and                 edx, 3
            //   33c9                 | xor                 ecx, ecx

        $sequence_6 = { 68???????? 68???????? 8d85f8feffff 50 ff15???????? 68???????? }
            // n = 6, score = 200
            //   68????????           |                     
            //   68????????           |                     
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_7 = { 8bcf e8???????? 8bd0 8bce e8???????? 83c404 }
            // n = 6, score = 200
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_8 = { 50 0fb744243a 50 68???????? 8d442450 682c010000 50 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   0fb744243a           | movzx               eax, word ptr [esp + 0x3a]
            //   50                   | push                eax
            //   68????????           |                     
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   682c010000           | push                0x12c
            //   50                   | push                eax

        $sequence_9 = { ff15???????? 85c0 7518 6860ea0000 ffd6 6a00 8d442428 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7518                 | jne                 0x1a
            //   6860ea0000           | push                0xea60
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   8d442428             | lea                 eax, [esp + 0x28]

    condition:
        7 of them and filesize < 313344
}