rule win_mydoom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.mydoom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.mydoom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b800000000 e9???????? 8b830c040000 800801 c744240402000000 8b4304 890424 }
            // n = 7, score = 100
            //   b800000000           | mov                 eax, 0
            //   e9????????           |                     
            //   8b830c040000         | mov                 eax, dword ptr [ebx + 0x40c]
            //   800801               | or                  byte ptr [eax], 1
            //   c744240402000000     | mov                 dword ptr [esp + 4], 2
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_1 = { 7502 89d0 5d c3 }
            // n = 4, score = 100
            //   7502                 | jne                 4
            //   89d0                 | mov                 eax, edx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_2 = { c7442404???????? 8d9d68ffffff 891c24 e8???????? c744240c28000000 8d8538ffffff 89442408 }
            // n = 7, score = 100
            //   c7442404????????     |                     
            //   8d9d68ffffff         | lea                 ebx, [ebp - 0x98]
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   c744240c28000000     | mov                 dword ptr [esp + 0xc], 0x28
            //   8d8538ffffff         | lea                 eax, [ebp - 0xc8]
            //   89442408             | mov                 dword ptr [esp + 8], eax

        $sequence_3 = { b000 f2ae f7d1 49 c781????????2e657865 }
            // n = 5, score = 100
            //   b000                 | mov                 al, 0
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   c781????????2e657865     |     

        $sequence_4 = { 0fb6442eb8 884707 e8???????? 89c6 }
            // n = 4, score = 100
            //   0fb6442eb8           | movzx               eax, byte ptr [esi + ebp - 0x48]
            //   884707               | mov                 byte ptr [edi + 7], al
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax

        $sequence_5 = { 8d9dc8f9ffff 891c24 e8???????? 8d8568f9ffff 89442424 89742420 }
            // n = 6, score = 100
            //   8d9dc8f9ffff         | lea                 ebx, [ebp - 0x638]
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   8d8568f9ffff         | lea                 eax, [ebp - 0x698]
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   89742420             | mov                 dword ptr [esp + 0x20], esi

        $sequence_6 = { 85c0 0f84cc000000 897c2410 8d85e0feffff 8944240c 89742408 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f84cc000000         | je                  0xd2
            //   897c2410             | mov                 dword ptr [esp + 0x10], edi
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   89742408             | mov                 dword ptr [esp + 8], esi

        $sequence_7 = { 8b5d08 8b4514 8945f4 c745f001000000 8d45f8 }
            // n = 5, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_8 = { ffd0 8b15???????? 83eb04 39d3 73eb 8d742600 }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   8b15????????         |                     
            //   83eb04               | sub                 ebx, 4
            //   39d3                 | cmp                 ebx, edx
            //   73eb                 | jae                 0xffffffed
            //   8d742600             | lea                 esi, [esi]

        $sequence_9 = { 83ec04 b800000000 eb21 8b85d8feffff 890424 e8???????? }
            // n = 6, score = 100
            //   83ec04               | sub                 esp, 4
            //   b800000000           | mov                 eax, 0
            //   eb21                 | jmp                 0x23
            //   8b85d8feffff         | mov                 eax, dword ptr [ebp - 0x128]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 114688
}