rule win_nabucur_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nabucur."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nabucur"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49 23cf 894c241c 3bc3 }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   23cf                 | and                 ecx, edi
            //   894c241c             | mov                 dword ptr [esp + 0x1c], ecx
            //   3bc3                 | cmp                 eax, ebx

        $sequence_1 = { 49 3b442430 891e 8944241c }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   3b442430             | cmp                 eax, dword ptr [esp + 0x30]
            //   891e                 | mov                 dword ptr [esi], ebx
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax

        $sequence_2 = { 49 23ce 894f18 8bf0 85c0 0f8521040000 }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   23ce                 | and                 ecx, esi
            //   894f18               | mov                 dword ptr [edi + 0x18], ecx
            //   8bf0                 | mov                 esi, eax
            //   85c0                 | test                eax, eax
            //   0f8521040000         | jne                 0x427

        $sequence_3 = { 49 40 0bf2 85c9 }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   40                   | inc                 eax
            //   0bf2                 | or                  esi, edx
            //   85c9                 | test                ecx, ecx

        $sequence_4 = { 49 23cb 894d08 5d }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   23cb                 | and                 ecx, ebx
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   5d                   | pop                 ebp

        $sequence_5 = { 33ff 397c2434 7e61 8b6c2434 }
            // n = 4, score = 200
            //   33ff                 | xor                 edi, edi
            //   397c2434             | cmp                 dword ptr [esp + 0x34], edi
            //   7e61                 | jle                 0x63
            //   8b6c2434             | mov                 ebp, dword ptr [esp + 0x34]

        $sequence_6 = { 009eaa030000 0fb686aa030000 57 83f80a 0f876d010000 }
            // n = 5, score = 200
            //   009eaa030000         | add                 byte ptr [esi + 0x3aa], bl
            //   0fb686aa030000       | movzx               eax, byte ptr [esi + 0x3aa]
            //   57                   | push                edi
            //   83f80a               | cmp                 eax, 0xa
            //   0f876d010000         | ja                  0x173

        $sequence_7 = { 49 03d3 40 85c9 75f4 8916 }
            // n = 6, score = 200
            //   49                   | dec                 ecx
            //   03d3                 | add                 edx, ebx
            //   40                   | inc                 eax
            //   85c9                 | test                ecx, ecx
            //   75f4                 | jne                 0xfffffff6
            //   8916                 | mov                 dword ptr [esi], edx

        $sequence_8 = { 8b4508 8b00 50 ff15???????? 83bdecfeffff00 }
            // n = 5, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83bdecfeffff00       | cmp                 dword ptr [ebp - 0x114], 0

        $sequence_9 = { 4d a1???????? 138df6adfe2a 44 b80c83f6cd }
            // n = 5, score = 100
            //   4d                   | dec                 ebp
            //   a1????????           |                     
            //   138df6adfe2a         | adc                 ecx, dword ptr [ebp + 0x2afeadf6]
            //   44                   | inc                 esp
            //   b80c83f6cd           | mov                 eax, 0xcdf6830c

        $sequence_10 = { 07 03fa d448 f242 26684ef6e738 46 28c1 }
            // n = 7, score = 100
            //   07                   | pop                 es
            //   03fa                 | add                 edi, edx
            //   d448                 | aam                 0x48
            //   f242                 | inc                 edx
            //   26684ef6e738         | push                0x38e7f64e
            //   46                   | inc                 esi
            //   28c1                 | sub                 cl, al

        $sequence_11 = { be???????? bbb31d3ff8 bb9a21baf8 eb7f 49 }
            // n = 5, score = 100
            //   be????????           |                     
            //   bbb31d3ff8           | mov                 ebx, 0xf83f1db3
            //   bb9a21baf8           | mov                 ebx, 0xf8ba219a
            //   eb7f                 | jmp                 0x81
            //   49                   | dec                 ecx

        $sequence_12 = { fa dc90fa3d14db 8736 6c 2f }
            // n = 5, score = 100
            //   fa                   | cli                 
            //   dc90fa3d14db         | fcom                qword ptr [eax - 0x24ebc206]
            //   8736                 | xchg                dword ptr [esi], esi
            //   6c                   | insb                byte ptr es:[edi], dx
            //   2f                   | das                 

        $sequence_13 = { 83f901 752e bae6c060fb eb1f 46 }
            // n = 5, score = 100
            //   83f901               | cmp                 ecx, 1
            //   752e                 | jne                 0x30
            //   bae6c060fb           | mov                 edx, 0xfb60c0e6
            //   eb1f                 | jmp                 0x21
            //   46                   | inc                 esi

        $sequence_14 = { 6695 09b899f00150 cf 1bf6 47 e5b8 }
            // n = 6, score = 100
            //   6695                 | xchg                ax, bp
            //   09b899f00150         | or                  dword ptr [eax + 0x5001f099], edi
            //   cf                   | iretd               
            //   1bf6                 | sbb                 esi, esi
            //   47                   | inc                 edi
            //   e5b8                 | in                  eax, 0xb8

        $sequence_15 = { 49 bbe19321fa e9???????? ba3665c4ff 3006 ebeb }
            // n = 6, score = 100
            //   49                   | dec                 ecx
            //   bbe19321fa           | mov                 ebx, 0xfa2193e1
            //   e9????????           |                     
            //   ba3665c4ff           | mov                 edx, 0xffc46536
            //   3006                 | xor                 byte ptr [esi], al
            //   ebeb                 | jmp                 0xffffffed

    condition:
        7 of them and filesize < 1949696
}