rule win_nefilim_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nefilim."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nefilim"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 c745f4e8a14000 e8???????? cc 8bff 55 8bec }
            // n = 7, score = 200
            //   50                   | push                eax
            //   c745f4e8a14000       | mov                 dword ptr [ebp - 0xc], 0x40a1e8
            //   e8????????           |                     
            //   cc                   | int3                
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { e9???????? 8975e4 33c0 39b8c8e74000 0f8491000000 ff45e4 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   33c0                 | xor                 eax, eax
            //   39b8c8e74000         | cmp                 dword ptr [eax + 0x40e7c8], edi
            //   0f8491000000         | je                  0x97
            //   ff45e4               | inc                 dword ptr [ebp - 0x1c]

        $sequence_2 = { ff75ec 68???????? 56 56 }
            // n = 4, score = 200
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   68????????           |                     
            //   56                   | push                esi
            //   56                   | push                esi

        $sequence_3 = { 56 56 895dc0 ff15???????? 56 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   56                   | push                esi
            //   895dc0               | mov                 dword ptr [ebp - 0x40], ebx
            //   ff15????????         |                     
            //   56                   | push                esi

        $sequence_4 = { ff15???????? 8144242890d00300 8b44241c 115c242c 3944242c 0f8c3dffffff 0f8f5d010000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8144242890d00300     | add                 dword ptr [esp + 0x28], 0x3d090
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   115c242c             | adc                 dword ptr [esp + 0x2c], ebx
            //   3944242c             | cmp                 dword ptr [esp + 0x2c], eax
            //   0f8c3dffffff         | jl                  0xffffff43
            //   0f8f5d010000         | jg                  0x163

        $sequence_5 = { 85c0 7434 68???????? 8d8424d0000000 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7434                 | je                  0x36
            //   68????????           |                     
            //   8d8424d0000000       | lea                 eax, [esp + 0xd0]

        $sequence_6 = { ffd6 85c0 0f84cc030000 68???????? 8d8424d0000000 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   0f84cc030000         | je                  0x3d2
            //   68????????           |                     
            //   8d8424d0000000       | lea                 eax, [esp + 0xd0]

        $sequence_7 = { 6a01 8d74246c e8???????? 83ec1c 8bcc 217910 33c0 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   8d74246c             | lea                 esi, [esp + 0x6c]
            //   e8????????           |                     
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   217910               | and                 dword ptr [ecx + 0x10], edi
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8b442418 8b4c241c 53 03c6 53 13cb }
            // n = 6, score = 200
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   53                   | push                ebx
            //   03c6                 | add                 eax, esi
            //   53                   | push                ebx
            //   13cb                 | adc                 ecx, ebx

        $sequence_9 = { 2bc8 83f901 770a 68???????? e8???????? 8d5801 6a00 }
            // n = 7, score = 200
            //   2bc8                 | sub                 ecx, eax
            //   83f901               | cmp                 ecx, 1
            //   770a                 | ja                  0xc
            //   68????????           |                     
            //   e8????????           |                     
            //   8d5801               | lea                 ebx, [eax + 1]
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 142336
}