rule win_ngioweb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ngioweb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ngioweb"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f852e010000 83c8ff 837d1002 7503 33c0 40 50 }
            // n = 7, score = 500
            //   0f852e010000         | jne                 0x134
            //   83c8ff               | or                  eax, 0xffffffff
            //   837d1002             | cmp                 dword ptr [ebp + 0x10], 2
            //   7503                 | jne                 5
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_1 = { 56 e8???????? 5e c20400 55 8bec 83ec1c }
            // n = 7, score = 500
            //   56                   | push                esi
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c

        $sequence_2 = { 57 e8???????? 85c0 0f85a7000000 6a12 5b eb28 }
            // n = 7, score = 500
            //   57                   | push                edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85a7000000         | jne                 0xad
            //   6a12                 | push                0x12
            //   5b                   | pop                 ebx
            //   eb28                 | jmp                 0x2a

        $sequence_3 = { 668955c6 66897dc4 66c745c26300 66c745c06900 66c745be4d00 66895dbc }
            // n = 6, score = 500
            //   668955c6             | mov                 word ptr [ebp - 0x3a], dx
            //   66897dc4             | mov                 word ptr [ebp - 0x3c], di
            //   66c745c26300         | mov                 word ptr [ebp - 0x3e], 0x63
            //   66c745c06900         | mov                 word ptr [ebp - 0x40], 0x69
            //   66c745be4d00         | mov                 word ptr [ebp - 0x42], 0x4d
            //   66895dbc             | mov                 word ptr [ebp - 0x44], bx

        $sequence_4 = { eb74 8d45b0 50 56 e8???????? 8bf0 56 }
            // n = 7, score = 500
            //   eb74                 | jmp                 0x76
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   56                   | push                esi

        $sequence_5 = { 8b5de8 ff4dec 8bc8 8b45f8 8bf9 897df8 0f855fffffff }
            // n = 7, score = 500
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   ff4dec               | dec                 dword ptr [ebp - 0x14]
            //   8bc8                 | mov                 ecx, eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8bf9                 | mov                 edi, ecx
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   0f855fffffff         | jne                 0xffffff65

        $sequence_6 = { 33c0 85c9 740e 663901 7409 41 }
            // n = 6, score = 500
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   740e                 | je                  0x10
            //   663901               | cmp                 word ptr [ecx], ax
            //   7409                 | je                  0xb
            //   41                   | inc                 ecx

        $sequence_7 = { c645f86c c645f764 c645f62e 884dfa e9???????? 3d26c60be2 }
            // n = 6, score = 500
            //   c645f86c             | mov                 byte ptr [ebp - 8], 0x6c
            //   c645f764             | mov                 byte ptr [ebp - 9], 0x64
            //   c645f62e             | mov                 byte ptr [ebp - 0xa], 0x2e
            //   884dfa               | mov                 byte ptr [ebp - 6], cl
            //   e9????????           |                     
            //   3d26c60be2           | cmp                 eax, 0xe20bc626

        $sequence_8 = { c3 55 8bec 6a04 8d4518 50 ff7514 }
            // n = 7, score = 500
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   6a04                 | push                4
            //   8d4518               | lea                 eax, [ebp + 0x18]
            //   50                   | push                eax
            //   ff7514               | push                dword ptr [ebp + 0x14]

        $sequence_9 = { 8b4544 3bc6 7406 8b08 50 ff5108 8b4550 }
            // n = 7, score = 500
            //   8b4544               | mov                 eax, dword ptr [ebp + 0x44]
            //   3bc6                 | cmp                 eax, esi
            //   7406                 | je                  8
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff5108               | call                dword ptr [ecx + 8]
            //   8b4550               | mov                 eax, dword ptr [ebp + 0x50]

    condition:
        7 of them and filesize < 204800
}