rule win_nightdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nightdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nightdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 57 8b7d08 85ff 7423 8b4774 c6476001 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   85ff                 | test                edi, edi
            //   7423                 | je                  0x25
            //   8b4774               | mov                 eax, dword ptr [edi + 0x74]
            //   c6476001             | mov                 byte ptr [edi + 0x60], 1

        $sequence_1 = { c745fc00000000 8b45e4 c70000040000 8b4de4 8b11 52 e8???????? }
            // n = 7, score = 100
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   c70000040000         | mov                 dword ptr [eax], 0x400
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_2 = { c7430404000000 8b7068 6a08 e8???????? 8bf8 83c40c 85ff }
            // n = 7, score = 100
            //   c7430404000000       | mov                 dword ptr [ebx + 4], 4
            //   8b7068               | mov                 esi, dword ptr [eax + 0x68]
            //   6a08                 | push                8
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c40c               | add                 esp, 0xc
            //   85ff                 | test                edi, edi

        $sequence_3 = { 50 8d45f4 64a300000000 8bf9 8bce 897db4 c745b000000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   8bce                 | mov                 ecx, esi
            //   897db4               | mov                 dword ptr [ebp - 0x4c], edi
            //   c745b000000000       | mov                 dword ptr [ebp - 0x50], 0

        $sequence_4 = { 8d7708 53 8d85e0feffff 897704 e8???????? 8bd8 83c410 }
            // n = 7, score = 100
            //   8d7708               | lea                 esi, [edi + 8]
            //   53                   | push                ebx
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c410               | add                 esp, 0x10

        $sequence_5 = { 8d460c 8d4ff4 8945fc 83c40c 33c0 85c9 742b }
            // n = 7, score = 100
            //   8d460c               | lea                 eax, [esi + 0xc]
            //   8d4ff4               | lea                 ecx, [edi - 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   742b                 | je                  0x2d

        $sequence_6 = { c645fc01 33db e8???????? 85c0 7468 68???????? 57 }
            // n = 7, score = 100
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   33db                 | xor                 ebx, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7468                 | je                  0x6a
            //   68????????           |                     
            //   57                   | push                edi

        $sequence_7 = { 8b8538feffff 50 e8???????? 59 c3 8d4dc0 }
            // n = 6, score = 100
            //   8b8538feffff         | mov                 eax, dword ptr [ebp - 0x1c8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]

        $sequence_8 = { 52 8b55ec 52 50 e8???????? 8b7e04 8b0e }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b7e04               | mov                 edi, dword ptr [esi + 4]
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_9 = { 8d55b8 52 e8???????? 898538ffffff 8b8d3cffffff e8???????? 8d8d4cffffff }
            // n = 7, score = 100
            //   8d55b8               | lea                 edx, [ebp - 0x48]
            //   52                   | push                edx
            //   e8????????           |                     
            //   898538ffffff         | mov                 dword ptr [ebp - 0xc8], eax
            //   8b8d3cffffff         | mov                 ecx, dword ptr [ebp - 0xc4]
            //   e8????????           |                     
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]

    condition:
        7 of them and filesize < 1124352
}