rule win_nim_blackout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nim_blackout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nim_blackout"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4510 488b4008 488b4018 488b4008 4889c2 b910000000 e8???????? }
            // n = 7, score = 100
            //   488b4510             | mov                 ecx, edi
            //   488b4008             | inc                 esp
            //   488b4018             | mov                 ebx, dword ptr [edx + 8]
            //   488b4008             | dec                 esp
            //   4889c2               | mov                 edx, dword ptr [edx]
            //   b910000000           | dec                 esp
            //   e8????????           |                     

        $sequence_1 = { 84c0 7405 e8???????? 488b8570ffffff 488945f0 90 e9???????? }
            // n = 7, score = 100
            //   84c0                 | dec                 eax
            //   7405                 | mov                 dword ptr [ebp + 0x20], 0x14d
            //   e8????????           |                     
            //   488b8570ffffff       | dec                 eax
            //   488945f0             | lea                 eax, [0xf621]
            //   90                   | dec                 eax
            //   e9????????           |                     

        $sequence_2 = { 488b4d10 e8???????? 488945b0 488b4510 488b00 480faf45e0 4889c1 }
            // n = 7, score = 100
            //   488b4d10             | mov                 dword ptr [ebp + 0x10], ecx
            //   e8????????           |                     
            //   488945b0             | dec                 eax
            //   488b4510             | add                 esp, 0x70
            //   488b00               | pop                 ebp
            //   480faf45e0           | ret                 
            //   4889c1               | push                ebp

        $sequence_3 = { 0f9fc0 888583000000 0fb68583000000 83f001 84c0 0f85c2010000 488b85a0000000 }
            // n = 7, score = 100
            //   0f9fc0               | dec                 eax
            //   888583000000         | mov                 dword ptr [ebp - 8], eax
            //   0fb68583000000       | dec                 eax
            //   83f001               | mov                 eax, dword ptr [ebp - 8]
            //   84c0                 | dec                 eax
            //   0f85c2010000         | add                 esp, 0x10
            //   488b85a0000000       | pop                 ebp

        $sequence_4 = { 488b45f0 4801d0 4883c010 c6002d eb1c 90 48c745d06c000000 }
            // n = 7, score = 100
            //   488b45f0             | mov                 dword ptr [ebp + 8], eax
            //   4801d0               | dec                 eax
            //   4883c010             | mov                 dword ptr [ebp + 0x88], 0
            //   c6002d               | dec                 eax
            //   eb1c                 | cmp                 dword ptr [ebp + 0x90], 0
            //   90                   | dec                 eax
            //   48c745d06c000000     | cmp                 dword ptr [ebp + 0x90], 0

        $sequence_5 = { 488d0583c80100 488945d8 48c705????????00000000 48c745d040010000 488d0565c80100 488945d8 48c705????????00000000 }
            // n = 7, score = 100
            //   488d0583c80100       | lea                 eax, [0x2779a]
            //   488945d8             | dec                 eax
            //   48c705????????00000000     |     
            //   48c745d040010000     | mov                 dword ptr [ebp - 0x28], eax
            //   488d0565c80100       | mov                 eax, dword ptr [ebp - 0xc]
            //   488945d8             | dec                 eax
            //   48c705????????00000000     |     

        $sequence_6 = { 488945d8 488d05d7fe0100 488945e8 48c745e000000000 66c745f00000 488d45d0 4889c1 }
            // n = 7, score = 100
            //   488945d8             | dec                 eax
            //   488d05d7fe0100       | add                 eax, 0x12
            //   488945e8             | mov                 edx, 0x20
            //   48c745e000000000     | dec                 eax
            //   66c745f00000         | mov                 ecx, eax
            //   488d45d0             | mov                 byte ptr [eax + 0x50], 0
            //   4889c1               | dec                 eax

        $sequence_7 = { 48c705????????08000000 c605????????16 488d0522c40200 488905???????? 488d05b4fdffff 488905???????? c605????????01 }
            // n = 7, score = 100
            //   48c705????????08000000     |     
            //   c605????????16       |                     
            //   488d0522c40200       | lea                 eax, [ebp - 0x70]
            //   488905????????       |                     
            //   488d05b4fdffff       | dec                 eax
            //   488905????????       |                     
            //   c605????????01       |                     

        $sequence_8 = { ba01000000 4889c1 488d45e8 488908 4889d0 83e001 84c0 }
            // n = 7, score = 100
            //   ba01000000           | mov                 ecx, eax
            //   4889c1               | dec                 eax
            //   488d45e8             | lea                 eax, [0x23afb]
            //   488908               | dec                 eax
            //   4889d0               | mov                 dword ptr [ebp - 0x28], eax
            //   83e001               | dec                 eax
            //   84c0                 | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_9 = { 7410 488b85a0000000 488b4038 488b00 eb05 b800000000 488b95a0000000 }
            // n = 7, score = 100
            //   7410                 | dec                 eax
            //   488b85a0000000       | lea                 eax, [0x235a6]
            //   488b4038             | dec                 eax
            //   488b00               | mov                 dword ptr [ebp - 0x28], eax
            //   eb05                 | dec                 eax
            //   b800000000           | mov                 edx, dword ptr [ebp - 8]
            //   488b95a0000000       | dec                 eax

    condition:
        7 of them and filesize < 1068032
}