rule win_nokki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nokki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nokki"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 33d2 68ce070000 52 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   68ce070000           | push                0x7ce
            //   52                   | push                edx

        $sequence_1 = { e8???????? 33c9 68ce070000 51 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   68ce070000           | push                0x7ce
            //   51                   | push                ecx

        $sequence_2 = { 39b890e94000 0f8491000000 ff45e4 83c030 3df0000000 }
            // n = 5, score = 100
            //   39b890e94000         | cmp                 dword ptr [eax + 0x40e990], edi
            //   0f8491000000         | je                  0x97
            //   ff45e4               | inc                 dword ptr [ebp - 0x1c]
            //   83c030               | add                 eax, 0x30
            //   3df0000000           | cmp                 eax, 0xf0

        $sequence_3 = { 50 8d8da8ddffff bfe8030000 51 89bd40d4ffff }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d8da8ddffff         | lea                 ecx, [ebp - 0x2258]
            //   bfe8030000           | mov                 edi, 0x3e8
            //   51                   | push                ecx
            //   89bd40d4ffff         | mov                 dword ptr [ebp - 0x2bc0], edi

        $sequence_4 = { 8bff 56 57 33ff ffb7b80d4100 }
            // n = 5, score = 100
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   ffb7b80d4100         | push                dword ptr [edi + 0x410db8]

        $sequence_5 = { e8???????? 59 59 8b7508 8d34f500ed4000 391e }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d34f500ed4000       | lea                 esi, [esi*8 + 0x40ed00]
            //   391e                 | cmp                 dword ptr [esi], ebx

        $sequence_6 = { c1f905 8b0c8dc02b4100 83e01f c1e006 f644080401 }
            // n = 5, score = 100
            //   c1f905               | sar                 ecx, 5
            //   8b0c8dc02b4100       | mov                 ecx, dword ptr [ecx*4 + 0x412bc0]
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   f644080401           | test                byte ptr [eax + ecx + 4], 1

        $sequence_7 = { a1???????? 8b500c b9???????? 895dfc c78554e8ffff01000000 ffd2 }
            // n = 6, score = 100
            //   a1????????           |                     
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]
            //   b9????????           |                     
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   c78554e8ffff01000000     | mov    dword ptr [ebp - 0x17ac], 1
            //   ffd2                 | call                edx

        $sequence_8 = { 47 897e14 897e70 c686c800000043 c6864b01000043 c7466860e54000 6a0d }
            // n = 7, score = 100
            //   47                   | inc                 edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   897e70               | mov                 dword ptr [esi + 0x70], edi
            //   c686c800000043       | mov                 byte ptr [esi + 0xc8], 0x43
            //   c6864b01000043       | mov                 byte ptr [esi + 0x14b], 0x43
            //   c7466860e54000       | mov                 dword ptr [esi + 0x68], 0x40e560
            //   6a0d                 | push                0xd

        $sequence_9 = { c1e006 03049580054100 eb05 b8???????? }
            // n = 4, score = 100
            //   c1e006               | shl                 eax, 6
            //   03049580054100       | add                 eax, dword ptr [edx*4 + 0x410580]
            //   eb05                 | jmp                 7
            //   b8????????           |                     

        $sequence_10 = { e9???????? 8bc6 c1f805 8bfe 53 8d1c85c02b4100 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8bfe                 | mov                 edi, esi
            //   53                   | push                ebx
            //   8d1c85c02b4100       | lea                 ebx, [eax*4 + 0x412bc0]

        $sequence_11 = { 7524 a1???????? a3???????? a1???????? c705????????6a464000 8935???????? a3???????? }
            // n = 7, score = 100
            //   7524                 | jne                 0x26
            //   a1????????           |                     
            //   a3????????           |                     
            //   a1????????           |                     
            //   c705????????6a464000     |     
            //   8935????????         |                     
            //   a3????????           |                     

        $sequence_12 = { 8bec 8b4508 ff34c5100a4100 ff15???????? 5d c3 6a0c }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c5100a4100       | push                dword ptr [eax*8 + 0x410a10]
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a0c                 | push                0xc

        $sequence_13 = { 741b 8b06 8bc8 c1f905 83e01f c1e006 8b0c8d80054100 }
            // n = 7, score = 100
            //   741b                 | je                  0x1d
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   c1f905               | sar                 ecx, 5
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   8b0c8d80054100       | mov                 ecx, dword ptr [ecx*4 + 0x410580]

    condition:
        7 of them and filesize < 454656
}