rule win_nokoyawa_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.nokoyawa."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.nokoyawa"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883e1c0 488b542470 488d4c0a20 488b542470 4883c220 4889542440 448bc0 }
            // n = 7, score = 100
            //   4883e1c0             | mov                 eax, dword ptr [esp + 0x30]
            //   488b542470           | inc                 eax
            //   488d4c0a20           | dec                 eax
            //   488b542470           | cwde                
            //   4883c220             | dec                 eax
            //   4889542440           | mov                 ecx, dword ptr [esp + 0x48]
            //   448bc0               | test                eax, eax

        $sequence_1 = { c744246820000000 c744246c6b000000 c744242000000000 eb0b 8b442420 83c014 }
            // n = 6, score = 100
            //   c744246820000000     | dec                 eax
            //   c744246c6b000000     | add                 eax, 0x70
            //   c744242000000000     | dec                 eax
            //   eb0b                 | mov                 edx, dword ptr [esp + 0x80]
            //   8b442420             | dec                 eax
            //   83c014               | mov                 ecx, eax

        $sequence_2 = { 890424 8b0424 d1e0 8b0c24 c1e91f 0bc1 89442474 }
            // n = 7, score = 100
            //   890424               | or                  edx, ecx
            //   8b0424               | mov                 ecx, edx
            //   d1e0                 | mov                 edx, dword ptr [esp + 0x70]
            //   8b0c24               | add                 edx, ecx
            //   c1e91f               | mov                 ecx, edx
            //   0bc1                 | shl                 edx, 5
            //   89442474             | or                  edx, ecx

        $sequence_3 = { c1e902 0bc1 8944240c 33c0 85c0 0f853effffff b804000000 }
            // n = 7, score = 100
            //   c1e902               | mov                 eax, ecx
            //   0bc1                 | mov                 ecx, 4
            //   8944240c             | dec                 eax
            //   33c0                 | imul                ecx, ecx, 7
            //   85c0                 | dec                 eax
            //   0f853effffff         | mov                 edx, dword ptr [esp + 0x50]
            //   b804000000           | dec                 eax

        $sequence_4 = { 488b442408 48ffc0 4889442408 0fb60424 83f861 7c0a 0fb60424 }
            // n = 7, score = 100
            //   488b442408           | mov                 dword ptr [esp + 0x140], eax
            //   48ffc0               | mov                 eax, 4
            //   4889442408           | dec                 eax
            //   0fb60424             | imul                eax, eax, 6
            //   83f861               | mov                 ecx, dword ptr [esp + 0x140]
            //   7c0a                 | mov                 dword ptr [esp + eax + 0x20], ecx
            //   0fb60424             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_5 = { c1e91f 0bc1 89842450010000 b804000000 486bc00a 8b8c2450010000 }
            // n = 6, score = 100
            //   c1e91f               | dec                 eax
            //   0bc1                 | mov                 dword ptr [esp + 0x10], eax
            //   89842450010000       | dec                 eax
            //   b804000000           | cmp                 dword ptr [esp + 0x40], 0xc
            //   486bc00a             | jae                 0xc8
            //   8b8c2450010000       | dec                 eax

        $sequence_6 = { 0bc1 89442410 33c0 85c0 0f853cffffff b804000000 486bc005 }
            // n = 7, score = 100
            //   0bc1                 | dec                 eax
            //   89442410             | add                 ecx, eax
            //   33c0                 | dec                 eax
            //   85c0                 | mov                 ecx, eax
            //   0f853cffffff         | jmp                 0x1e3d
            //   b804000000           | cmp                 dword ptr [esp + 0x44], 0x103
            //   486bc005             | je                  0x1e3d

        $sequence_7 = { c744242000000000 4c8b0d???????? 4c8d058f030000 33d2 }
            // n = 4, score = 100
            //   c744242000000000     | mov                 eax, ecx
            //   4c8b0d????????       |                     
            //   4c8d058f030000       | dec                 eax
            //   33d2                 | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_8 = { 33c0 85c0 0f8528ffffff b804000000 486bc008 }
            // n = 5, score = 100
            //   33c0                 | mov                 eax, eax
            //   85c0                 | dec                 eax
            //   0f8528ffffff         | lea                 eax, [eax*8 + 8]
            //   b804000000           | mov                 ecx, 2
            //   486bc008             | mov                 dword ptr [esp + 0x48], eax

        $sequence_9 = { e9???????? 0fb6442421 85c0 7419 8b442424 33c9 488b542438 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   0fb6442421           | shl                 eax, 0x18
            //   85c0                 | dec                 eax
            //   7419                 | mov                 ecx, dword ptr [esp + 0x40]
            //   8b442424             | dec                 eax
            //   33c9                 | add                 ecx, 0xc
            //   488b542438           | mov                 edx, eax

    condition:
        7 of them and filesize < 92160
}