rule win_olympic_destroyer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.olympic_destroyer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.olympic_destroyer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 33c0 89542414 57 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   33c0                 | xor                 eax, eax
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   57                   | push                edi

        $sequence_1 = { 89442448 e8???????? 83c404 85c0 0f84e1010000 8d842494000000 }
            // n = 6, score = 100
            //   89442448             | mov                 dword ptr [esp + 0x48], eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   0f84e1010000         | je                  0x1e7
            //   8d842494000000       | lea                 eax, [esp + 0x94]

        $sequence_2 = { c70424???????? e8???????? bb???????? c70424???????? e8???????? bb???????? }
            // n = 6, score = 100
            //   c70424????????       |                     
            //   e8????????           |                     
            //   bb????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   bb????????           |                     

        $sequence_3 = { 83c620 3b442418 72ba 8b742420 817c242403010000 }
            // n = 5, score = 100
            //   83c620               | add                 esi, 0x20
            //   3b442418             | cmp                 eax, dword ptr [esp + 0x18]
            //   72ba                 | jb                  0xffffffbc
            //   8b742420             | mov                 esi, dword ptr [esp + 0x20]
            //   817c242403010000     | cmp                 dword ptr [esp + 0x24], 0x103

        $sequence_4 = { 83f807 77c4 ff248571335400 8bce e8???????? }
            // n = 5, score = 100
            //   83f807               | cmp                 eax, 7
            //   77c4                 | ja                  0xffffffc6
            //   ff248571335400       | jmp                 dword ptr [eax*4 + 0x543371]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_5 = { 8bd6 897c2418 8906 e8???????? 83c404 85c0 7470 }
            // n = 7, score = 100
            //   8bd6                 | mov                 edx, esi
            //   897c2418             | mov                 dword ptr [esp + 0x18], edi
            //   8906                 | mov                 dword ptr [esi], eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7470                 | je                  0x72

        $sequence_6 = { 68???????? ba???????? e8???????? 83c418 85c0 0f84eb000000 a1???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   ba????????           |                     
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f84eb000000         | je                  0xf1
            //   a1????????           |                     

        $sequence_7 = { 50 6a02 8bcf e8???????? 8b451c }
            // n = 5, score = 100
            //   50                   | push                eax
            //   6a02                 | push                2
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]

        $sequence_8 = { 50 6a01 ff7510 e8???????? 83c41c 8bf0 807f4500 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8bf0                 | mov                 esi, eax
            //   807f4500             | cmp                 byte ptr [edi + 0x45], 0

        $sequence_9 = { 50 6a03 e8???????? 8b542440 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   6a03                 | push                3
            //   e8????????           |                     
            //   8b542440             | mov                 edx, dword ptr [esp + 0x40]

        $sequence_10 = { 6a28 50 ff15???????? 56 56 6a10 8d45ec }
            // n = 7, score = 100
            //   6a28                 | push                0x28
            //   50                   | push                eax
            //   ff15????????         |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   6a10                 | push                0x10
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_11 = { 50 6a02 ff75e4 ff15???????? 85c0 74c0 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   74c0                 | je                  0xffffffc2

        $sequence_12 = { 8d442424 ba09000000 50 8d4c2420 }
            // n = 4, score = 100
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   ba09000000           | mov                 edx, 9
            //   50                   | push                eax
            //   8d4c2420             | lea                 ecx, [esp + 0x20]

        $sequence_13 = { 68???????? bb???????? e8???????? bb???????? c70424???????? e8???????? bb???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   bb????????           |                     
            //   e8????????           |                     
            //   bb????????           |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   bb????????           |                     

        $sequence_14 = { 8d85c0f9ffff 50 ffd7 85c0 747a ffb590f9ffff e8???????? }
            // n = 7, score = 100
            //   8d85c0f9ffff         | lea                 eax, [ebp - 0x640]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   747a                 | je                  0x7c
            //   ffb590f9ffff         | push                dword ptr [ebp - 0x670]
            //   e8????????           |                     

        $sequence_15 = { 6aff 6a04 6aff ff75ec 8945f0 }
            // n = 5, score = 100
            //   6aff                 | push                -1
            //   6a04                 | push                4
            //   6aff                 | push                -1
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_16 = { 50 6a05 6a00 ff742444 ff742438 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   6a05                 | push                5
            //   6a00                 | push                0
            //   ff742444             | push                dword ptr [esp + 0x44]
            //   ff742438             | push                dword ptr [esp + 0x38]

        $sequence_17 = { c744241cd0f25500 894c2424 c744242c00000000 751b }
            // n = 4, score = 100
            //   c744241cd0f25500     | mov                 dword ptr [esp + 0x1c], 0x55f2d0
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx
            //   c744242c00000000     | mov                 dword ptr [esp + 0x2c], 0
            //   751b                 | jne                 0x1d

        $sequence_18 = { 0f85f5feffff ffb58cf9ffff ff15???????? 8b4df8 5f 5e 33cd }
            // n = 7, score = 100
            //   0f85f5feffff         | jne                 0xfffffefb
            //   ffb58cf9ffff         | push                dword ptr [ebp - 0x674]
            //   ff15????????         |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33cd                 | xor                 ecx, ebp

        $sequence_19 = { 56 8d85e4efffff 50 6a01 8d85f8efffff 50 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   8d85e4efffff         | lea                 eax, [ebp - 0x101c]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   8d85f8efffff         | lea                 eax, [ebp - 0x1008]
            //   50                   | push                eax

        $sequence_20 = { 50 6a01 ff742424 e8???????? 83c40c 8b7f08 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8b7f08               | mov                 edi, dword ptr [edi + 8]

        $sequence_21 = { 8d542404 56 8bf1 e8???????? 85c0 7416 }
            // n = 6, score = 100
            //   8d542404             | lea                 edx, [esp + 4]
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18

        $sequence_22 = { 50 6a04 e8???????? 8b45fc 33d2 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   6a04                 | push                4
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   33d2                 | xor                 edx, edx

    condition:
        7 of them and filesize < 1392640
}