rule win_onionduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.onionduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.onionduke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 663bcf 75f5 2bc6 d1f8 740c 8b45fc 8b08 }
            // n = 7, score = 200
            //   663bcf               | cmp                 cx, di
            //   75f5                 | jne                 0xfffffff7
            //   2bc6                 | sub                 eax, esi
            //   d1f8                 | sar                 eax, 1
            //   740c                 | je                  0xe
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_1 = { 51 8d4dd4 e8???????? 8b45e4 }
            // n = 4, score = 200
            //   51                   | push                ecx
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_2 = { 8b45e0 7303 8d45e0 6a00 6a00 6a03 }
            // n = 6, score = 200
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   7303                 | jae                 5
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a03                 | push                3

        $sequence_3 = { 40 84c9 75f9 2b45cc }
            // n = 4, score = 200
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2b45cc               | sub                 eax, dword ptr [ebp - 0x34]

        $sequence_4 = { 51 e8???????? 8bf8 8bc6 83c404 8d5001 8d9b00000000 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8bc6                 | mov                 eax, esi
            //   83c404               | add                 esp, 4
            //   8d5001               | lea                 edx, [eax + 1]
            //   8d9b00000000         | lea                 ebx, [ebx]

        $sequence_5 = { ff15???????? 85c0 78d8 8b45fc 8b550c 8b08 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   78d8                 | js                  0xffffffda
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_6 = { 64a300000000 8bf1 8975f0 c706???????? c745fc01000000 8b4608 }
            // n = 6, score = 200
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf1                 | mov                 esi, ecx
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   c706????????         |                     
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8b4608               | mov                 eax, dword ptr [esi + 8]

        $sequence_7 = { 33d2 3955f0 0f94c2 837df410 8bf2 720c }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   3955f0               | cmp                 dword ptr [ebp - 0x10], edx
            //   0f94c2               | sete                dl
            //   837df410             | cmp                 dword ptr [ebp - 0xc], 0x10
            //   8bf2                 | mov                 esi, edx
            //   720c                 | jb                  0xe

        $sequence_8 = { 8b4dfc 33cd e8???????? 8be5 5d c20400 837df408 }
            // n = 7, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   837df408             | cmp                 dword ptr [ebp - 0xc], 8

        $sequence_9 = { 50 8d45e0 50 e8???????? 837df408 8b45e0 7303 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   e8????????           |                     
            //   837df408             | cmp                 dword ptr [ebp - 0xc], 8
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   7303                 | jae                 5

    condition:
        7 of them and filesize < 671744
}