rule win_pay2key_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pay2key."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pay2key"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 84db 74cc 8ac3 8b4df4 64890d00000000 59 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   84db                 | test                bl, bl
            //   74cc                 | je                  0xffffffce
            //   8ac3                 | mov                 al, bl
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx

        $sequence_1 = { a1???????? 33c5 50 8d45f4 64a300000000 8965f0 0f1f8000000000 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   0f1f8000000000       | nop                 dword ptr [eax]

        $sequence_2 = { c745fc00000000 8b4610 85c0 7420 a801 7515 83e0fe }
            // n = 7, score = 300
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | test                eax, eax
            //   7420                 | je                  0x22
            //   a801                 | test                al, 1
            //   7515                 | jne                 0x17
            //   83e0fe               | and                 eax, 0xfffffffe

        $sequence_3 = { 8bbde0000000 85ff 741f 8bc3 f00fc14704 7516 8b07 }
            // n = 7, score = 300
            //   8bbde0000000         | mov                 edi, dword ptr [ebp + 0xe0]
            //   85ff                 | test                edi, edi
            //   741f                 | je                  0x21
            //   8bc3                 | mov                 eax, ebx
            //   f00fc14704           | lock xadd           dword ptr [edi + 4], eax
            //   7516                 | jne                 0x18
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_4 = { 83c102 84d2 75d8 33c0 }
            // n = 4, score = 300
            //   83c102               | add                 ecx, 2
            //   84d2                 | test                dl, dl
            //   75d8                 | jne                 0xffffffda
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 8b7a08 8bc7 8b5a0c 0bc3 7512 3bca 0f94c0 }
            // n = 7, score = 300
            //   8b7a08               | mov                 edi, dword ptr [edx + 8]
            //   8bc7                 | mov                 eax, edi
            //   8b5a0c               | mov                 ebx, dword ptr [edx + 0xc]
            //   0bc3                 | or                  eax, ebx
            //   7512                 | jne                 0x14
            //   3bca                 | cmp                 ecx, edx
            //   0f94c0               | sete                al

        $sequence_6 = { 8b4f10 894508 85c9 742f 8908 f6c101 }
            // n = 6, score = 300
            //   8b4f10               | mov                 ecx, dword ptr [edi + 0x10]
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   85c9                 | test                ecx, ecx
            //   742f                 | je                  0x31
            //   8908                 | mov                 dword ptr [eax], ecx
            //   f6c101               | test                cl, 1

        $sequence_7 = { 50 8d45f4 64a300000000 8b410c 83c10c 6a00 ff5028 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b410c               | mov                 eax, dword ptr [ecx + 0xc]
            //   83c10c               | add                 ecx, 0xc
            //   6a00                 | push                0
            //   ff5028               | call                dword ptr [eax + 0x28]

        $sequence_8 = { 6a02 50 e8???????? 8b4de4 83c410 3bc1 7716 }
            // n = 7, score = 300
            //   6a02                 | push                2
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c410               | add                 esp, 0x10
            //   3bc1                 | cmp                 eax, ecx
            //   7716                 | ja                  0x18

        $sequence_9 = { d1e8 03c2 3bc1 0f43c8 894df8 8d048d04000000 50 }
            // n = 7, score = 300
            //   d1e8                 | shr                 eax, 1
            //   03c2                 | add                 eax, edx
            //   3bc1                 | cmp                 eax, ecx
            //   0f43c8               | cmovae              ecx, eax
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8d048d04000000       | lea                 eax, [ecx*4 + 4]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 2252800
}