rule win_playwork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.playwork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.playwork"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 50 897510 ff7308 }
            // n = 4, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   897510               | mov                 dword ptr [ebp + 0x10], esi
            //   ff7308               | push                dword ptr [ebx + 8]

        $sequence_1 = { 8975e0 8b75f0 8b0c8d344f3f00 c1ee18 330cb534573f00 330c9534533f00 8b55f4 }
            // n = 7, score = 100
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   8b0c8d344f3f00       | mov                 ecx, dword ptr [ecx*4 + 0x3f4f34]
            //   c1ee18               | shr                 esi, 0x18
            //   330cb534573f00       | xor                 ecx, dword ptr [esi*4 + 0x3f5734]
            //   330c9534533f00       | xor                 ecx, dword ptr [edx*4 + 0x3f5334]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_2 = { eb02 33c0 c1e008 0bc6 8a9f5c8e3f00 c1e008 0bc6 }
            // n = 7, score = 100
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   c1e008               | shl                 eax, 8
            //   0bc6                 | or                  eax, esi
            //   8a9f5c8e3f00         | mov                 bl, byte ptr [edi + 0x3f8e5c]
            //   c1e008               | shl                 eax, 8
            //   0bc6                 | or                  eax, esi

        $sequence_3 = { ffd6 80a56cfeffff00 6a1f 59 33c0 8dbd6dfeffff 6880000000 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   80a56cfeffff00       | and                 byte ptr [ebp - 0x194], 0
            //   6a1f                 | push                0x1f
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   8dbd6dfeffff         | lea                 edi, [ebp - 0x193]
            //   6880000000           | push                0x80

        $sequence_4 = { 85c0 7520 ff75fc 8b35???????? ffd6 ff7508 ffd6 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7520                 | jne                 0x22
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd6                 | call                esi

        $sequence_5 = { c1ca08 8bda 8bc2 c1eb10 c1e818 0fb6db }
            // n = 6, score = 100
            //   c1ca08               | ror                 edx, 8
            //   8bda                 | mov                 ebx, edx
            //   8bc2                 | mov                 eax, edx
            //   c1eb10               | shr                 ebx, 0x10
            //   c1e818               | shr                 eax, 0x18
            //   0fb6db               | movzx               ebx, bl

        $sequence_6 = { 33c0 c1e008 0bc5 c1e008 0b442410 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   c1e008               | shl                 eax, 8
            //   0bc5                 | or                  eax, ebp
            //   c1e008               | shl                 eax, 8
            //   0b442410             | or                  eax, dword ptr [esp + 0x10]

        $sequence_7 = { ff75f4 ff15???????? ff75f0 eb01 57 ff15???????? }
            // n = 6, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   eb01                 | jmp                 3
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { 53 53 68???????? ff75fc ffd6 85c0 5f }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   68????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi

        $sequence_9 = { 81c41c640000 c3 55 8bec 81ecb8030000 53 56 }
            // n = 7, score = 100
            //   81c41c640000         | add                 esp, 0x641c
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecb8030000         | sub                 esp, 0x3b8
            //   53                   | push                ebx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 360448
}