rule win_powershellrunner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.powershellrunner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powershellrunner"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498bce ff15???????? 488bd8 eb02 33db 4c8d35e900ffff 4885db }
            // n = 7, score = 200
            //   498bce               | mov                 esi, 0x40000
            //   ff15????????         |                     
            //   488bd8               | dec                 eax
            //   eb02                 | mov                 dword ptr [esp + 8], ebx
            //   33db                 | push                edi
            //   4c8d35e900ffff       | dec                 eax
            //   4885db               | sub                 esp, 0x20

        $sequence_1 = { 488d058f9b0000 488bd9 483bc8 7417 8b815c010000 85c0 750d }
            // n = 7, score = 200
            //   488d058f9b0000       | jne                 0x151d
            //   488bd9               | dec                 eax
            //   483bc8               | mov                 ecx, dword ptr [esp + 0x20]
            //   7417                 | inc                 ebp
            //   8b815c010000         | xor                 ecx, ecx
            //   85c0                 | inc                 ebp
            //   750d                 | xor                 eax, eax

        $sequence_2 = { 4053 4883ec20 8bd9 4c8d0d19300100 b901000000 4c8d0505300100 488d1506300100 }
            // n = 7, score = 200
            //   4053                 | mov                 byte ptr [esp + 0x2c6], 0x3a
            //   4883ec20             | mov                 byte ptr [esp + 0x2c7], 0x21
            //   8bd9                 | mov                 byte ptr [esp + 0xc3], 0x3b
            //   4c8d0d19300100       | mov                 byte ptr [esp + 0xc4], 0x36
            //   b901000000           | mov                 byte ptr [esp + 0xc5], 0x34
            //   4c8d0505300100       | mov                 byte ptr [esp + 0xc6], 0x21
            //   488d1506300100       | mov                 byte ptr [esp + 0xc7], 0x55

        $sequence_3 = { 4c8d8424a0000000 33d2 488b4c2438 ff15???????? 85c0 }
            // n = 5, score = 200
            //   4c8d8424a0000000     | mov                 ecx, dword ptr [esp + 0x130]
            //   33d2                 | dec                 eax
            //   488b4c2438           | cmp                 dword ptr [esp + 0x28], 0
            //   ff15????????         |                     
            //   85c0                 | je                  0x191d

        $sequence_4 = { 4439ac24b8000000 0f87de000000 03bc24b8000000 488b542440 4c8d1d841d0100 }
            // n = 5, score = 200
            //   4439ac24b8000000     | mov                 byte ptr [esp + 0x2a6], 0x23
            //   0f87de000000         | mov                 byte ptr [esp + 0x2a7], 0x30
            //   03bc24b8000000       | mov                 byte ptr [esp + 0x2a8], 0x27
            //   488b542440           | mov                 byte ptr [esp + 0xa6], 0x55
            //   4c8d1d841d0100       | mov                 byte ptr [esp + 0x50], 0x33

        $sequence_5 = { 85c0 7439 488b542438 488b4c2440 e8???????? }
            // n = 5, score = 200
            //   85c0                 | dec                 eax
            //   7439                 | lea                 eax, [0x150ad]
            //   488b542438           | dec                 eax
            //   488b4c2440           | mov                 dword ptr [ebx], eax
            //   e8????????           |                     

        $sequence_6 = { 488b442460 488b4c2470 488d4488fc 488bc8 e8???????? 488b4c2460 488b542468 }
            // n = 7, score = 200
            //   488b442460           | lea                 ecx, [esp + 0x140]
            //   488b4c2470           | test                eax, eax
            //   488d4488fc           | jne                 0xa31
            //   488bc8               | cmp                 eax, 0x10b
            //   e8????????           |                     
            //   488b4c2460           | xor                 edx, edx
            //   488b542468           | dec                 ecx

        $sequence_7 = { c68424a000000033 c68424a100000036 c68424a200000039 c68424a30000003a c68424a400000026 c68424a500000030 c68424a600000055 }
            // n = 7, score = 200
            //   c68424a000000033     | mov                 eax, 0x69
            //   c68424a100000036     | mov                 word ptr [esp + 0xf0], ax
            //   c68424a200000039     | mov                 eax, 0x61
            //   c68424a30000003a     | mov                 word ptr [esp + 0xf2], ax
            //   c68424a400000026     | mov                 word ptr [esp + 0xec], ax
            //   c68424a500000030     | mov                 eax, 0x6f
            //   c68424a600000055     | mov                 word ptr [esp + 0xee], ax

        $sequence_8 = { ff15???????? e8???????? 85c0 7426 488d442434 4889442428 c744242000000000 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   e8????????           |                     
            //   85c0                 | mov                 word ptr [esp + 0x166], ax
            //   7426                 | mov                 eax, 0x34
            //   488d442434           | mov                 eax, 0x73
            //   4889442428           | mov                 word ptr [esp + 0x172], ax
            //   c744242000000000     | mov                 eax, 0x65

        $sequence_9 = { 4533c0 488b542458 33c9 ff15???????? 85c0 7529 488b4c2458 }
            // n = 7, score = 200
            //   4533c0               | mov                 eax, dword ptr [esp + 0xb0]
            //   488b542458           | dec                 eax
            //   33c9                 | mov                 dword ptr [eax], 0
            //   ff15????????         |                     
            //   85c0                 | mov                 edx, dword ptr [esp + 0xa0]
            //   7529                 | mov                 dword ptr [eax], 0
            //   488b4c2458           | mov                 eax, dword ptr [esp + 0x5c]

    condition:
        7 of them and filesize < 458752
}