rule win_prometei_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.prometei."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prometei"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 011d???????? 03c8 8b5de4 a1???????? }
            // n = 4, score = 100
            //   011d????????         |                     
            //   03c8                 | add                 ecx, eax
            //   8b5de4               | mov                 ebx, dword ptr [ebp - 0x1c]
            //   a1????????           |                     

        $sequence_1 = { 68???????? c745d800000000 ff15???????? 8bf0 }
            // n = 4, score = 100
            //   68????????           |                     
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_2 = { 014364 8b45e4 014368 5b }
            // n = 4, score = 100
            //   014364               | add                 dword ptr [ebx + 0x64], eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   014368               | add                 dword ptr [ebx + 0x68], eax
            //   5b                   | pop                 ebx

        $sequence_3 = { 013d???????? 8b04b5c8054400 0500080000 3bc8 }
            // n = 4, score = 100
            //   013d????????         |                     
            //   8b04b5c8054400       | mov                 eax, dword ptr [esi*4 + 0x4405c8]
            //   0500080000           | add                 eax, 0x800
            //   3bc8                 | cmp                 ecx, eax

        $sequence_4 = { c745d4433a5c57 8b45d4 f30f7f05???????? a3???????? 6a03 c745d8696e646f 8b45d8 }
            // n = 7, score = 100
            //   c745d4433a5c57       | mov                 dword ptr [ebp - 0x2c], 0x575c3a43
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   f30f7f05????????     |                     
            //   a3????????           |                     
            //   6a03                 | push                3
            //   c745d8696e646f       | mov                 dword ptr [ebp - 0x28], 0x6f646e69
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]

        $sequence_5 = { 014368 81434400020000 c7434000000000 83534800 }
            // n = 4, score = 100
            //   014368               | add                 dword ptr [ebx + 0x68], eax
            //   81434400020000       | add                 dword ptr [ebx + 0x44], 0x200
            //   c7434000000000       | mov                 dword ptr [ebx + 0x40], 0
            //   83534800             | adc                 dword ptr [ebx + 0x48], 0

        $sequence_6 = { 89500c b801000000 f745c000020000 8bd1 0f44f8 8bc1 2bc7 }
            // n = 7, score = 100
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   b801000000           | mov                 eax, 1
            //   f745c000020000       | test                dword ptr [ebp - 0x40], 0x200
            //   8bd1                 | mov                 edx, ecx
            //   0f44f8               | cmove               edi, eax
            //   8bc1                 | mov                 eax, ecx
            //   2bc7                 | sub                 eax, edi

        $sequence_7 = { 014360 8b45f4 014364 8b45e4 }
            // n = 4, score = 100
            //   014360               | add                 dword ptr [ebx + 0x60], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   014364               | add                 dword ptr [ebx + 0x64], eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_8 = { 8bc7 bf1f000000 897004 8b75fc 894808 89500c b801000000 }
            // n = 7, score = 100
            //   8bc7                 | mov                 eax, edi
            //   bf1f000000           | mov                 edi, 0x1f
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   b801000000           | mov                 eax, 1

        $sequence_9 = { 8d7db0 8907 8bc7 bf1f000000 897004 894808 8b4de0 }
            // n = 7, score = 100
            //   8d7db0               | lea                 edi, [ebp - 0x50]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8bc7                 | mov                 eax, edi
            //   bf1f000000           | mov                 edi, 0x1f
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_10 = { b815141414 2b45e0 3bf8 7425 8bd7 85ff }
            // n = 6, score = 100
            //   b815141414           | mov                 eax, 0x14141415
            //   2b45e0               | sub                 eax, dword ptr [ebp - 0x20]
            //   3bf8                 | cmp                 edi, eax
            //   7425                 | je                  0x27
            //   8bd7                 | mov                 edx, edi
            //   85ff                 | test                edi, edi

        $sequence_11 = { 01435c 8b45fc 014360 8b45f4 }
            // n = 4, score = 100
            //   01435c               | add                 dword ptr [ebx + 0x5c], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   014360               | add                 dword ptr [ebx + 0x60], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_12 = { 014358 8b45f0 01435c 8b45fc }
            // n = 4, score = 100
            //   014358               | add                 dword ptr [ebx + 0x58], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   01435c               | add                 dword ptr [ebx + 0x5c], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_13 = { 44 b46b d6 1e }
            // n = 4, score = 100
            //   44                   | inc                 esp
            //   b46b                 | mov                 ah, 0x6b
            //   d6                   | salc                
            //   1e                   | push                ds

        $sequence_14 = { 014354 8b45e8 014358 8b45f0 }
            // n = 4, score = 100
            //   014354               | add                 dword ptr [ebx + 0x54], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   014358               | add                 dword ptr [ebx + 0x58], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_15 = { a3???????? c605????????00 c745e82e646c6c 8b45e8 }
            // n = 4, score = 100
            //   a3????????           |                     
            //   c605????????00       |                     
            //   c745e82e646c6c       | mov                 dword ptr [ebp - 0x18], 0x6c6c642e
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]

    condition:
        7 of them and filesize < 51014656
}