rule win_pseudo_manuscrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pseudo_manuscrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pseudo_manuscrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8d45ec 50 68???????? 56 e8???????? 83c420 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20

        $sequence_1 = { 85c0 747c 6a0d ff15???????? 85c0 746a 53 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   747c                 | je                  0x7e
            //   6a0d                 | push                0xd
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   746a                 | je                  0x6c
            //   53                   | push                ebx

        $sequence_2 = { 689c000000 81c684000000 6a00 ff36 ff15???????? 8bf8 }
            // n = 6, score = 200
            //   689c000000           | push                0x9c
            //   81c684000000         | add                 esi, 0x84
            //   6a00                 | push                0
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_3 = { 7513 ffb518f7ffff ffd6 fec3 80fb7a 0f8e68ffffff 8b35???????? }
            // n = 7, score = 200
            //   7513                 | jne                 0x15
            //   ffb518f7ffff         | push                dword ptr [ebp - 0x8e8]
            //   ffd6                 | call                esi
            //   fec3                 | inc                 bl
            //   80fb7a               | cmp                 bl, 0x7a
            //   0f8e68ffffff         | jle                 0xffffff6e
            //   8b35????????         |                     

        $sequence_4 = { 83ec08 a1???????? 33c5 8945fc 56 8bf1 83be9c02000000 }
            // n = 7, score = 200
            //   83ec08               | sub                 esp, 8
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   83be9c02000000       | cmp                 dword ptr [esi + 0x29c], 0

        $sequence_5 = { 42 8841ff 3b550c 72ef e9???????? b8d34d6210 f7eb }
            // n = 7, score = 200
            //   42                   | inc                 edx
            //   8841ff               | mov                 byte ptr [ecx - 1], al
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]
            //   72ef                 | jb                  0xfffffff1
            //   e9????????           |                     
            //   b8d34d6210           | mov                 eax, 0x10624dd3
            //   f7eb                 | imul                ebx

        $sequence_6 = { 85f6 7e16 8bce e8???????? 8bd6 8d8d34ffffff e8???????? }
            // n = 7, score = 200
            //   85f6                 | test                esi, esi
            //   7e16                 | jle                 0x18
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   8d8d34ffffff         | lea                 ecx, [ebp - 0xcc]
            //   e8????????           |                     

        $sequence_7 = { e8???????? 85c0 0f8517010000 56 50 8b4614 ff30 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8517010000         | jne                 0x11d
            //   56                   | push                esi
            //   50                   | push                eax
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   ff30                 | push                dword ptr [eax]

        $sequence_8 = { 8910 8b45f4 83f808 720a 40 50 ff75e0 }
            // n = 7, score = 200
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83f808               | cmp                 eax, 8
            //   720a                 | jb                  0xc
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   ff75e0               | push                dword ptr [ebp - 0x20]

        $sequence_9 = { 6a06 6a01 50 ff15???????? 8bc8 894e1c 83f9ff }
            // n = 7, score = 200
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   894e1c               | mov                 dword ptr [esi + 0x1c], ecx
            //   83f9ff               | cmp                 ecx, -1

    condition:
        7 of them and filesize < 753664
}