rule win_pss_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.pss."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pss"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d48fe e8???????? e9???????? 83f811 }
            // n = 4, score = 300
            //   8d48fe               | lea                 ecx, [eax - 2]
            //   e8????????           |                     
            //   e9????????           |                     
            //   83f811               | cmp                 eax, 0x11

        $sequence_1 = { 7437 ff15???????? 3de5030000 752a }
            // n = 4, score = 300
            //   7437                 | je                  0x39
            //   ff15????????         |                     
            //   3de5030000           | cmp                 eax, 0x3e5
            //   752a                 | jne                 0x2c

        $sequence_2 = { ff15???????? 83ceff 3bc6 7504 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   83ceff               | or                  esi, 0xffffffff
            //   3bc6                 | cmp                 eax, esi
            //   7504                 | jne                 6

        $sequence_3 = { 740a 50 ffd6 830d????????ff a1???????? 85c0 740a }
            // n = 7, score = 200
            //   740a                 | je                  0xc
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   830d????????ff       |                     
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc

        $sequence_4 = { 8d85eafdffff 56 50 e8???????? 83c40c }
            // n = 5, score = 200
            //   8d85eafdffff         | lea                 eax, [ebp - 0x216]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 8d4dc0 e8???????? eb23 8d45a4 }
            // n = 4, score = 200
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   e8????????           |                     
            //   eb23                 | jmp                 0x25
            //   8d45a4               | lea                 eax, [ebp - 0x5c]

        $sequence_6 = { ff15???????? 56 53 8d4c2414 8bf8 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   8bf8                 | mov                 edi, eax

        $sequence_7 = { 50 8995a4f9ffff 899da0f9ffff 83cfff e8???????? 6848040000 8d85b0fbffff }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8995a4f9ffff         | mov                 dword ptr [ebp - 0x65c], edx
            //   899da0f9ffff         | mov                 dword ptr [ebp - 0x660], ebx
            //   83cfff               | or                  edi, 0xffffffff
            //   e8????????           |                     
            //   6848040000           | push                0x448
            //   8d85b0fbffff         | lea                 eax, [ebp - 0x450]

        $sequence_8 = { 4889442448 488d15f5710100 488d4c2428 e8???????? 90 4c8d050bbe0000 }
            // n = 6, score = 100
            //   4889442448           | nop                 
            //   488d15f5710100       | dec                 eax
            //   488d4c2428           | cmp                 dword ptr [esp + 0x40], 8
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   4c8d050bbe0000       | lea                 eax, [0x1bc0c]

        $sequence_9 = { 488d050cbc0100 488b4c2430 483bc8 7405 }
            // n = 4, score = 100
            //   488d050cbc0100       | dec                 eax
            //   488b4c2430           | mov                 edx, eax
            //   483bc8               | dec                 eax
            //   7405                 | lea                 ecx, [0x16ad9]

        $sequence_10 = { 488bd0 488d0dd96a0100 e8???????? 90 48837c244008 }
            // n = 5, score = 100
            //   488bd0               | mov                 ecx, dword ptr [ecx]
            //   488d0dd96a0100       | inc                 ecx
            //   e8????????           |                     
            //   90                   | cmp                 byte ptr [ecx + 0x19], ch
            //   48837c244008         | jne                 0x15

        $sequence_11 = { 0f859d040000 498d4810 498bd8 4c8b09 41386919 7513 }
            // n = 6, score = 100
            //   0f859d040000         | jne                 0x4a3
            //   498d4810             | dec                 ecx
            //   498bd8               | lea                 ecx, [eax + 0x10]
            //   4c8b09               | dec                 ecx
            //   41386919             | mov                 ebx, eax
            //   7513                 | dec                 esp

        $sequence_12 = { 488bcd 895c2470 e8???????? 48634c2470 4803c9 }
            // n = 5, score = 100
            //   488bcd               | dec                 eax
            //   895c2470             | mov                 ecx, dword ptr [esp + 0x30]
            //   e8????????           |                     
            //   48634c2470           | dec                 eax
            //   4803c9               | cmp                 ecx, eax

    condition:
        7 of them and filesize < 421888
}