rule win_qaccel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.qaccel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qaccel"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bd0 0f87ea010000 e9???????? 8b4df4 33ff 81e1ffff0000 }
            // n = 6, score = 100
            //   3bd0                 | cmp                 edx, eax
            //   0f87ea010000         | ja                  0x1f0
            //   e9????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   33ff                 | xor                 edi, edi
            //   81e1ffff0000         | and                 ecx, 0xffff

        $sequence_1 = { 6a0c 8bd8 ffd7 8bf8 8b4620 8d55f0 52 }
            // n = 7, score = 100
            //   6a0c                 | push                0xc
            //   8bd8                 | mov                 ebx, eax
            //   ffd7                 | call                edi
            //   8bf8                 | mov                 edi, eax
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx

        $sequence_2 = { 41 83c210 894df8 8b1b }
            // n = 4, score = 100
            //   41                   | inc                 ecx
            //   83c210               | add                 edx, 0x10
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b1b                 | mov                 ebx, dword ptr [ebx]

        $sequence_3 = { 85c0 0f84b8000000 0f8810000000 0f890a000000 5f }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84b8000000         | je                  0xbe
            //   0f8810000000         | js                  0x16
            //   0f890a000000         | jns                 0x10
            //   5f                   | pop                 edi

        $sequence_4 = { 0f8488000000 53 57 56 8d4d9c e8???????? 8b7da0 }
            // n = 7, score = 100
            //   0f8488000000         | je                  0x8e
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   8d4d9c               | lea                 ecx, [ebp - 0x64]
            //   e8????????           |                     
            //   8b7da0               | mov                 edi, dword ptr [ebp - 0x60]

        $sequence_5 = { 33c0 8d95fcfeffff f2ae f7d1 2bf9 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d95fcfeffff         | lea                 edx, [ebp - 0x104]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx

        $sequence_6 = { 8b45fc 51 8b4df4 2bc1 2bc7 40 99 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   2bc1                 | sub                 eax, ecx
            //   2bc7                 | sub                 eax, edi
            //   40                   | inc                 eax
            //   99                   | cdq                 

        $sequence_7 = { 8b1d???????? f7d1 49 742d 8945fc 8d45fc }
            // n = 6, score = 100
            //   8b1d????????         |                     
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   742d                 | je                  0x2f
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_8 = { 03da 668b03 50 ffd6 668b4b02 8bf8 51 }
            // n = 7, score = 100
            //   03da                 | add                 ebx, edx
            //   668b03               | mov                 ax, word ptr [ebx]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   668b4b02             | mov                 cx, word ptr [ebx + 2]
            //   8bf8                 | mov                 edi, eax
            //   51                   | push                ecx

        $sequence_9 = { f3a4 668b4df8 668903 66894b02 ff15???????? }
            // n = 5, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   668b4df8             | mov                 cx, word ptr [ebp - 8]
            //   668903               | mov                 word ptr [ebx], ax
            //   66894b02             | mov                 word ptr [ebx + 2], cx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 106496
}