rule win_qakbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.qakbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qakbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 7402 ebfa e8???????? }
            // n = 4, score = 15500
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   e8????????           |                     

        $sequence_1 = { 7402 ebfa 33c0 7402 }
            // n = 4, score = 15400
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_2 = { 7402 ebfa eb06 33c0 }
            // n = 4, score = 14900
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   eb06                 | jmp                 8
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { e8???????? 33c9 85c0 0f9fc1 41 }
            // n = 5, score = 14800
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   85c0                 | test                eax, eax
            //   0f9fc1               | setg                cl
            //   41                   | inc                 ecx

        $sequence_4 = { 50 e8???????? 8b06 47 }
            // n = 4, score = 14400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   47                   | inc                 edi

        $sequence_5 = { 59 59 6afb e9???????? }
            // n = 4, score = 13800
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   6afb                 | push                -5
            //   e9????????           |                     

        $sequence_6 = { 740d 8d45fc 6a00 50 e8???????? 59 }
            // n = 6, score = 13700
            //   740d                 | je                  0xf
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_7 = { 50 8d8534f6ffff 6a00 50 }
            // n = 4, score = 13700
            //   50                   | push                eax
            //   8d8534f6ffff         | lea                 eax, [ebp - 0x9cc]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_8 = { 8945fc e8???????? 8bf0 8d45fc 50 e8???????? }
            // n = 6, score = 13500
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 50 e8???????? 59 59 6afe 58 }
            // n = 6, score = 13500
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   6afe                 | push                -2
            //   58                   | pop                 eax

        $sequence_10 = { 33c0 e9???????? 33c0 7402 }
            // n = 4, score = 13400
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_11 = { 7402 ebfa e9???????? 6a00 }
            // n = 4, score = 13200
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   e9????????           |                     
            //   6a00                 | push                0

        $sequence_12 = { 7cef eb10 c644301c00 ff465c 8b465c }
            // n = 5, score = 13000
            //   7cef                 | jl                  0xfffffff1
            //   eb10                 | jmp                 0x12
            //   c644301c00           | mov                 byte ptr [eax + esi + 0x1c], 0
            //   ff465c               | inc                 dword ptr [esi + 0x5c]
            //   8b465c               | mov                 eax, dword ptr [esi + 0x5c]

        $sequence_13 = { e8???????? 83c410 33c0 7402 }
            // n = 4, score = 12800
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_14 = { 85c0 750a 33c0 7402 }
            // n = 4, score = 12700
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_15 = { 7507 c7466401000000 83f840 7507 }
            // n = 4, score = 12400
            //   7507                 | jne                 9
            //   c7466401000000       | mov                 dword ptr [esi + 0x64], 1
            //   83f840               | cmp                 eax, 0x40
            //   7507                 | jne                 9

        $sequence_16 = { 837dfc00 750b 33c0 7402 }
            // n = 4, score = 12300
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   750b                 | jne                 0xd
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_17 = { e8???????? e8???????? 33c0 7402 }
            // n = 4, score = 12300
            //   e8????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_18 = { 833d????????00 7508 33c0 7402 }
            // n = 4, score = 12100
            //   833d????????00       |                     
            //   7508                 | jne                 0xa
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_19 = { c7466001000000 33c0 40 5e }
            // n = 4, score = 11900
            //   c7466001000000       | mov                 dword ptr [esi + 0x60], 1
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5e                   | pop                 esi

        $sequence_20 = { 7402 ebfa 837d1000 7408 }
            // n = 4, score = 11600
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7408                 | je                  0xa

        $sequence_21 = { 80ea80 8855f0 e8???????? 0fb64df7 }
            // n = 4, score = 11600
            //   80ea80               | sub                 dl, 0x80
            //   8855f0               | mov                 byte ptr [ebp - 0x10], dl
            //   e8????????           |                     
            //   0fb64df7             | movzx               ecx, byte ptr [ebp - 9]

        $sequence_22 = { 7eeb 83f861 7c05 83f87a 7ee1 }
            // n = 5, score = 11500
            //   7eeb                 | jle                 0xffffffed
            //   83f861               | cmp                 eax, 0x61
            //   7c05                 | jl                  7
            //   83f87a               | cmp                 eax, 0x7a
            //   7ee1                 | jle                 0xffffffe3

        $sequence_23 = { 83f841 7c05 83f85a 7eeb }
            // n = 4, score = 11500
            //   83f841               | cmp                 eax, 0x41
            //   7c05                 | jl                  7
            //   83f85a               | cmp                 eax, 0x5a
            //   7eeb                 | jle                 0xffffffed

        $sequence_24 = { e8???????? 59 85c0 7505 6afe }
            // n = 5, score = 11200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   6afe                 | push                -2

        $sequence_25 = { 8d45bc 6a20 50 e8???????? 6a00 8d45bc 50 }
            // n = 7, score = 11100
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   6a20                 | push                0x20
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a00                 | push                0
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax

        $sequence_26 = { e8???????? 833822 7505 83c8ff }
            // n = 4, score = 10100
            //   e8????????           |                     
            //   833822               | cmp                 dword ptr [eax], 0x22
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_27 = { b301 eb0c 813800300000 b302 7202 }
            // n = 5, score = 9800
            //   b301                 | mov                 bl, 1
            //   eb0c                 | jmp                 0xe
            //   813800300000         | cmp                 dword ptr [eax], 0x3000
            //   b302                 | mov                 bl, 2
            //   7202                 | jb                  4

        $sequence_28 = { 7418 813800200000 7304 b301 }
            // n = 4, score = 9800
            //   7418                 | je                  0x1a
            //   813800200000         | cmp                 dword ptr [eax], 0x2000
            //   7304                 | jae                 6
            //   b301                 | mov                 bl, 1

        $sequence_29 = { c1e81e 33448afc 69c06589076c 03c1 89048a ff82c0090000 81bac009000070020000 }
            // n = 7, score = 9600
            //   c1e81e               | shr                 eax, 0x1e
            //   33448afc             | xor                 eax, dword ptr [edx + ecx*4 - 4]
            //   69c06589076c         | imul                eax, eax, 0x6c078965
            //   03c1                 | add                 eax, ecx
            //   89048a               | mov                 dword ptr [edx + ecx*4], eax
            //   ff82c0090000         | inc                 dword ptr [edx + 0x9c0]
            //   81bac009000070020000     | cmp    dword ptr [edx + 0x9c0], 0x270

        $sequence_30 = { 50 8d45d8 50 8d45d4 50 8d45ec 50 }
            // n = 7, score = 9500
            //   50                   | push                eax
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_31 = { ff10 85c0 750b ff15???????? e9???????? }
            // n = 5, score = 9500
            //   ff10                 | call                dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   750b                 | jne                 0xd
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_32 = { 56 e8???????? 8b45fc 83c40c 40 }
            // n = 5, score = 9500
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c40c               | add                 esp, 0xc
            //   40                   | inc                 eax

        $sequence_33 = { 83f801 7513 85c9 7507 e8???????? 8bc8 890d???????? }
            // n = 7, score = 9300
            //   83f801               | cmp                 eax, 1
            //   7513                 | jne                 0x15
            //   85c9                 | test                ecx, ecx
            //   7507                 | jne                 9
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   890d????????         |                     

        $sequence_34 = { 6a00 6800600900 6a00 ff15???????? a3???????? }
            // n = 5, score = 8800
            //   6a00                 | push                0
            //   6800600900           | push                0x96000
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_35 = { e8???????? 33c0 c3 55 8bec 51 51 }
            // n = 7, score = 8500
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_36 = { 50 ff5508 8bf0 59 }
            // n = 4, score = 6300
            //   50                   | push                eax
            //   ff5508               | call                dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_37 = { 6a00 58 0f95c0 40 50 }
            // n = 5, score = 5800
            //   6a00                 | push                0
            //   58                   | pop                 eax
            //   0f95c0               | setne               al
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_38 = { c3 33c9 3d80000000 0f94c1 }
            // n = 4, score = 5200
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   3d80000000           | cmp                 eax, 0x80
            //   0f94c1               | sete                cl

        $sequence_39 = { 85c0 750c 57 ff15???????? 6afe 58 }
            // n = 6, score = 5200
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6afe                 | push                -2
            //   58                   | pop                 eax

        $sequence_40 = { 57 ff15???????? 33c0 85f6 0f94c0 }
            // n = 5, score = 5200
            //   57                   | push                edi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   85f6                 | test                esi, esi
            //   0f94c0               | sete                al

        $sequence_41 = { 6a02 ff15???????? 8bf8 83c8ff }
            // n = 4, score = 5000
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_42 = { 5e 33c0 c9 c3 55 8bec }
            // n = 6, score = 4800
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_43 = { 56 e8???????? 83c40c 8d4514 50 }
            // n = 5, score = 4000
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   50                   | push                eax

        $sequence_44 = { e8???????? e8???????? e8???????? e8???????? e8???????? 85c0 7405 }
            // n = 7, score = 2800
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7

        $sequence_45 = { c7871002000001000000 8bc3 eb02 33c0 }
            // n = 4, score = 2800
            //   c7871002000001000000     | mov    dword ptr [edi + 0x210], 1
            //   8bc3                 | mov                 eax, ebx
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_46 = { 7505 83c8ff eb51 8b0a }
            // n = 4, score = 1700
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb51                 | jmp                 0x53
            //   8b0a                 | mov                 ecx, dword ptr [edx]

        $sequence_47 = { 8a040a 8801 48ffc1 84c0 740e 49ffc8 }
            // n = 6, score = 800
            //   8a040a               | mov                 al, byte ptr [edx + ecx]
            //   8801                 | mov                 byte ptr [ecx], al
            //   48ffc1               | dec                 eax
            //   84c0                 | inc                 ecx
            //   740e                 | test                al, al
            //   49ffc8               | je                  0x10

        $sequence_48 = { c745df03000000 8975f3 c745f705000000 83780406 }
            // n = 4, score = 800
            //   c745df03000000       | je                  0x12
            //   8975f3               | dec                 ecx
            //   c745f705000000       | dec                 eax
            //   83780406             | dec                 ecx

        $sequence_49 = { e8???????? ba05000000 48898424180a0000 488d4c2420 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   ba05000000           | mov                 dword ptr [ebp - 0xd], esi
            //   48898424180a0000     | mov                 dword ptr [ebp - 9], 5
            //   488d4c2420           | cmp                 dword ptr [eax + 4], 6

        $sequence_50 = { e8???????? 6a00 8d45d4 50 68???????? }
            // n = 5, score = 500
            //   e8????????           |                     
            //   6a00                 | push                0
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_51 = { 5d c3 33c9 66890c46 }
            // n = 4, score = 300
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   66890c46             | mov                 word ptr [esi + eax*2], cx

        $sequence_52 = { 803c3000 75f9 5f 5e 5d c3 c6040600 }
            // n = 7, score = 100
            //   803c3000             | cmp                 byte ptr [eax + esi], 0
            //   75f9                 | jne                 0xfffffffb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   c6040600             | mov                 byte ptr [esi + eax], 0

        $sequence_53 = { 894c245c 0f847afdffff e9???????? 31c0 8b8c2480000000 8b542450 }
            // n = 6, score = 100
            //   894c245c             | mov                 dword ptr [esp + 0x5c], ecx
            //   0f847afdffff         | je                  0xfffffd80
            //   e9????????           |                     
            //   31c0                 | xor                 eax, eax
            //   8b8c2480000000       | mov                 ecx, dword ptr [esp + 0x80]
            //   8b542450             | mov                 edx, dword ptr [esp + 0x50]

        $sequence_54 = { c7042400000000 c744240400b00300 c744240800100000 c744240c04000000 }
            // n = 4, score = 100
            //   c7042400000000       | mov                 dword ptr [esp], 0
            //   c744240400b00300     | mov                 dword ptr [esp + 4], 0x3b000
            //   c744240800100000     | mov                 dword ptr [esp + 8], 0x1000
            //   c744240c04000000     | mov                 dword ptr [esp + 0xc], 4

        $sequence_55 = { 89442428 8b442420 8b485c 8b542418 8b32 01ce }
            // n = 6, score = 100
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b485c               | mov                 ecx, dword ptr [eax + 0x5c]
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8b32                 | mov                 esi, dword ptr [edx]
            //   01ce                 | add                 esi, ecx

        $sequence_56 = { 19ce 8a8c2495000000 80f12a 8a2d???????? 89842488000000 }
            // n = 5, score = 100
            //   19ce                 | sbb                 esi, ecx
            //   8a8c2495000000       | mov                 cl, byte ptr [esp + 0x95]
            //   80f12a               | xor                 cl, 0x2a
            //   8a2d????????         |                     
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax

        $sequence_57 = { 0f48c1 33c9 66894c7efe 85c0 791d }
            // n = 5, score = 100
            //   0f48c1               | cmovs               eax, ecx
            //   33c9                 | xor                 ecx, ecx
            //   66894c7efe           | mov                 word ptr [esi + edi*2 - 2], cx
            //   85c0                 | test                eax, eax
            //   791d                 | jns                 0x1f

        $sequence_58 = { 8b85c0faffff 85c0 7407 50 ff15???????? }
            // n = 5, score = 100
            //   8b85c0faffff         | mov                 eax, dword ptr [ebp - 0x540]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_59 = { 8b542474 8b742440 035610 8944243c 89542438 eb55 8b442464 }
            // n = 7, score = 100
            //   8b542474             | mov                 edx, dword ptr [esp + 0x74]
            //   8b742440             | mov                 esi, dword ptr [esp + 0x40]
            //   035610               | add                 edx, dword ptr [esi + 0x10]
            //   8944243c             | mov                 dword ptr [esp + 0x3c], eax
            //   89542438             | mov                 dword ptr [esp + 0x38], edx
            //   eb55                 | jmp                 0x57
            //   8b442464             | mov                 eax, dword ptr [esp + 0x64]

        $sequence_60 = { 7437 8b45d0 c745c801000000 85db 741d 8d50f8 8d4f08 }
            // n = 7, score = 100
            //   7437                 | je                  0x39
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   c745c801000000       | mov                 dword ptr [ebp - 0x38], 1
            //   85db                 | test                ebx, ebx
            //   741d                 | je                  0x1f
            //   8d50f8               | lea                 edx, [eax - 8]
            //   8d4f08               | lea                 ecx, [edi + 8]

        $sequence_61 = { 890c24 89442410 e8???????? 8b4c2414 890c24 8944240c }
            // n = 6, score = 100
            //   890c24               | mov                 dword ptr [esp], ecx
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   e8????????           |                     
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax

        $sequence_62 = { e9???????? 8b44246c 8b4c2468 01c8 8b942480000000 8b74247c }
            // n = 6, score = 100
            //   e9????????           |                     
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]
            //   8b4c2468             | mov                 ecx, dword ptr [esp + 0x68]
            //   01c8                 | add                 eax, ecx
            //   8b942480000000       | mov                 edx, dword ptr [esp + 0x80]
            //   8b74247c             | mov                 esi, dword ptr [esp + 0x7c]

        $sequence_63 = { 8b442418 8b4c2450 8a1401 8a74243b 80cefa }
            // n = 5, score = 100
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   8a1401               | mov                 dl, byte ptr [ecx + eax]
            //   8a74243b             | mov                 dh, byte ptr [esp + 0x3b]
            //   80cefa               | or                  dh, 0xfa

    condition:
        7 of them and filesize < 4883456
}