rule win_ransomexx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ransomexx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransomexx"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 897708 8d7b50 3bfe 7439 8b4f08 3bce }
            // n = 6, score = 100
            //   897708               | mov                 dword ptr [edi + 8], esi
            //   8d7b50               | lea                 edi, [ebx + 0x50]
            //   3bfe                 | cmp                 edi, esi
            //   7439                 | je                  0x3b
            //   8b4f08               | mov                 ecx, dword ptr [edi + 8]
            //   3bce                 | cmp                 ecx, esi

        $sequence_1 = { 3bc1 744b 8d542420 52 }
            // n = 4, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   744b                 | je                  0x4d
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   52                   | push                edx

        $sequence_2 = { 13542440 894838 8b4c247c 034c242c 89503c 8b942480000000 13542430 }
            // n = 7, score = 100
            //   13542440             | adc                 edx, dword ptr [esp + 0x40]
            //   894838               | mov                 dword ptr [eax + 0x38], ecx
            //   8b4c247c             | mov                 ecx, dword ptr [esp + 0x7c]
            //   034c242c             | add                 ecx, dword ptr [esp + 0x2c]
            //   89503c               | mov                 dword ptr [eax + 0x3c], edx
            //   8b942480000000       | mov                 edx, dword ptr [esp + 0x80]
            //   13542430             | adc                 edx, dword ptr [esp + 0x30]

        $sequence_3 = { 57 8d45e0 e8???????? 8bf8 83c404 3bfb 0f8506020000 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c404               | add                 esp, 4
            //   3bfb                 | cmp                 edi, ebx
            //   0f8506020000         | jne                 0x20c

        $sequence_4 = { 83c204 c6462400 8955f0 8b5dfc 8ad0 80e27f 029018b44100 }
            // n = 7, score = 100
            //   83c204               | add                 edx, 4
            //   c6462400             | mov                 byte ptr [esi + 0x24], 0
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   8ad0                 | mov                 dl, al
            //   80e27f               | and                 dl, 0x7f
            //   029018b44100         | add                 dl, byte ptr [eax + 0x41b418]

        $sequence_5 = { c1ee03 33fe 03df 8b7dfc 039c3db8feffff 8bb43d94feffff 03f3 }
            // n = 7, score = 100
            //   c1ee03               | shr                 esi, 3
            //   33fe                 | xor                 edi, esi
            //   03df                 | add                 ebx, edi
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   039c3db8feffff       | add                 ebx, dword ptr [ebp + edi - 0x148]
            //   8bb43d94feffff       | mov                 esi, dword ptr [ebp + edi - 0x16c]
            //   03f3                 | add                 esi, ebx

        $sequence_6 = { 33f7 8b7d08 83c004 c1e608 8955ec 8945fc c1ef08 }
            // n = 7, score = 100
            //   33f7                 | xor                 esi, edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   83c004               | add                 eax, 4
            //   c1e608               | shl                 esi, 8
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   c1ef08               | shr                 edi, 8

        $sequence_7 = { 89442440 89442444 89442448 e8???????? 83c40c 83bc248800000000 8d842490020000 }
            // n = 7, score = 100
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   89442444             | mov                 dword ptr [esp + 0x44], eax
            //   89442448             | mov                 dword ptr [esp + 0x48], eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83bc248800000000     | cmp                 dword ptr [esp + 0x88], 0
            //   8d842490020000       | lea                 eax, [esp + 0x290]

        $sequence_8 = { 83c404 85c0 7539 8b55fc 8917 5f }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   85c0                 | test                eax, eax
            //   7539                 | jne                 0x3b
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8917                 | mov                 dword ptr [edi], edx
            //   5f                   | pop                 edi

        $sequence_9 = { 8975dc 3338 8bda 897dec 8bfe c1ef10 81e7ff000000 }
            // n = 7, score = 100
            //   8975dc               | mov                 dword ptr [ebp - 0x24], esi
            //   3338                 | xor                 edi, dword ptr [eax]
            //   8bda                 | mov                 ebx, edx
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   8bfe                 | mov                 edi, esi
            //   c1ef10               | shr                 edi, 0x10
            //   81e7ff000000         | and                 edi, 0xff

    condition:
        7 of them and filesize < 372736
}