rule win_rapid_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rapid_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rapid_ransom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 6801000004 6800a40000 ff75f8 ff15???????? }
            // n = 5, score = 300
            //   50                   | push                eax
            //   6801000004           | push                0x4000001
            //   6800a40000           | push                0xa400
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_1 = { 894dec e8???????? 6a6a 8d87ea010000 8d8e00020000 50 51 }
            // n = 7, score = 200
            //   894dec               | mov                 dword ptr [ebp - 0x14], ecx
            //   e8????????           |                     
            //   6a6a                 | push                0x6a
            //   8d87ea010000         | lea                 eax, [edi + 0x1ea]
            //   8d8e00020000         | lea                 ecx, [esi + 0x200]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_2 = { e8???????? 33d2 8d7f01 f7f6 80c261 8857ff 4b }
            // n = 7, score = 200
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   8d7f01               | lea                 edi, [edi + 1]
            //   f7f6                 | div                 esi
            //   80c261               | add                 dl, 0x61
            //   8857ff               | mov                 byte ptr [edi - 1], dl
            //   4b                   | dec                 ebx

        $sequence_3 = { 7402 b301 ff75fc ff15???????? 6a00 ff75f8 }
            // n = 6, score = 200
            //   7402                 | je                  4
            //   b301                 | mov                 bl, 1
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_4 = { 85c0 7474 8d45fc c745fc00000000 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7474                 | je                  0x76
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_5 = { 6800010000 50 56 8b35???????? 6a00 6a01 }
            // n = 6, score = 200
            //   6800010000           | push                0x100
            //   50                   | push                eax
            //   56                   | push                esi
            //   8b35????????         |                     
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_6 = { ff74243c ff15???????? 8a4c240e 84c9 }
            // n = 4, score = 200
            //   ff74243c             | push                dword ptr [esp + 0x3c]
            //   ff15????????         |                     
            //   8a4c240e             | mov                 cl, byte ptr [esp + 0xe]
            //   84c9                 | test                cl, cl

        $sequence_7 = { 8d44240e 50 ff7510 8d442440 56 50 ff5514 }
            // n = 7, score = 200
            //   8d44240e             | lea                 eax, [esp + 0xe]
            //   50                   | push                eax
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d442440             | lea                 eax, [esp + 0x40]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff5514               | call                dword ptr [ebp + 0x14]

        $sequence_8 = { 6a00 50 e8???????? 8b45fc 83c40c c60000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c40c               | add                 esp, 0xc
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_9 = { 8b35???????? 33ff c705????????00000000 85f6 }
            // n = 4, score = 100
            //   8b35????????         |                     
            //   33ff                 | xor                 edi, edi
            //   c705????????00000000     |     
            //   85f6                 | test                esi, esi

        $sequence_10 = { 83c404 8bc6 5e 5f c3 6a09 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   6a09                 | push                9

        $sequence_11 = { 56 e8???????? 83c404 ff75d4 e8???????? 83c404 53 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ff75d4               | push                dword ptr [ebp - 0x2c]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   53                   | push                ebx

        $sequence_12 = { c745d400000000 50 57 ff15???????? }
            // n = 4, score = 100
            //   c745d400000000       | mov                 dword ptr [ebp - 0x2c], 0
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_13 = { 83fa1a 0f8cddfeffff 68???????? e8???????? }
            // n = 4, score = 100
            //   83fa1a               | cmp                 edx, 0x1a
            //   0f8cddfeffff         | jl                  0xfffffee3
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_14 = { 58 6bc000 c78034c9410002000000 6a04 58 6bc000 }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c78034c9410002000000     | mov    dword ptr [eax + 0x41c934], 2
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0

    condition:
        7 of them and filesize < 286720
}