rule win_remcom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.remcom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remcom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4dec 8b55e8 8b1d???????? 8d45ec 50 51 }
            // n = 6, score = 100
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b1d????????         |                     
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_1 = { 8955f8 c745fc01000000 ff15???????? 8bf0 85f6 74a5 }
            // n = 6, score = 100
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   74a5                 | je                  0xffffffa7

        $sequence_2 = { 8b55e4 8b45d0 52 50 ff15???????? 85c0 }
            // n = 6, score = 100
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 8d45e0 50 c745f400000000 ffd7 6a01 6a00 }
            // n = 6, score = 100
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0
            //   ffd7                 | call                edi
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_4 = { 8b07 8b5704 51 50 8945d0 8955d4 ff15???????? }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b5704               | mov                 edx, dword ptr [edi + 4]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   ff15????????         |                     

        $sequence_5 = { 56 e8???????? 8bc6 c1f805 8b0485e0fc4000 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8b0485e0fc4000       | mov                 eax, dword ptr [eax*4 + 0x40fce0]

        $sequence_6 = { ff15???????? 56 ff15???????? 56 ff15???????? 68???????? ff15???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_7 = { 51 50 8945d0 8955d4 ff15???????? 85c0 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 83f9ff 7432 837e40ff 742c 83f8ff 7427 8b3d???????? }
            // n = 7, score = 100
            //   83f9ff               | cmp                 ecx, -1
            //   7432                 | je                  0x34
            //   837e40ff             | cmp                 dword ptr [esi + 0x40], -1
            //   742c                 | je                  0x2e
            //   83f8ff               | cmp                 eax, -1
            //   7427                 | je                  0x29
            //   8b3d????????         |                     

        $sequence_9 = { e8???????? 83c414 8b45fc ff34c52ce44000 53 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff34c52ce44000       | push                dword ptr [eax*8 + 0x40e42c]
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 155648
}