rule win_rising_sun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rising_sun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rising_sun"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b8a48000000 4883c138 e9???????? 488b8a48000000 4883c160 e9???????? }
            // n = 6, score = 100
            //   488b8a48000000       | mov                 dword ptr [ebp + 0x1d8], 0xa175eab7
            //   4883c138             | mov                 dword ptr [ebp + 0x1dc], 0x25638e34
            //   e9????????           |                     
            //   488b8a48000000       | mov                 dword ptr [ebp + 0x1e0], 0xdd17b8da
            //   4883c160             | mov                 dword ptr [ebp + 0x2d0], 0x61835909
            //   e9????????           |                     

        $sequence_1 = { 44886c2440 488d8db8000000 4883bdd000000008 480f438db8000000 bf03000000 4c8b85c8000000 4c3bc7 }
            // n = 7, score = 100
            //   44886c2440           | mov                 dword ptr [ebp - 0x78], esp
            //   488d8db8000000       | mov                 edx, 0x100
            //   4883bdd000000008     | dec                 eax
            //   480f438db8000000     | lea                 ecx, [esp + 0x68]
            //   bf03000000           | dec                 esp
            //   4c8b85c8000000       | mov                 dword ptr [ebp], esp
            //   4c3bc7               | inc                 sp

        $sequence_2 = { 4533c9 4533d2 488bd9 4963f8 }
            // n = 4, score = 100
            //   4533c9               | lea                 ecx, [ebp + 0x6c0]
            //   4533d2               | inc                 ecx
            //   488bd9               | mov                 eax, 1
            //   4963f8               | inc                 ecx

        $sequence_3 = { 488b8d10030000 4833cc e8???????? 4c8d9c2420040000 498b5b28 498b7330 498b7b38 }
            // n = 7, score = 100
            //   488b8d10030000       | jne                 0x4fc
            //   4833cc               | dec                 eax
            //   e8????????           |                     
            //   4c8d9c2420040000     | mov                 ecx, dword ptr [esi + 0xb8]
            //   498b5b28             | dec                 esp
            //   498b7330             | lea                 esp, [0x141cf]
            //   498b7b38             | lock dec            dword ptr [ecx]

        $sequence_4 = { 0f8498feffff 488d5506 488bcb ff15???????? 488905???????? 4885c0 0f847bfeffff }
            // n = 7, score = 100
            //   0f8498feffff         | dec                 eax
            //   488d5506             | lea                 ecx, [ebp + 0x6130]
            //   488bcb               | dec                 eax
            //   ff15????????         |                     
            //   488905????????       |                     
            //   4885c0               | test                eax, eax
            //   0f847bfeffff         | dec                 eax

        $sequence_5 = { 4181f9000000c0 7532 4585d2 756e 488d4b04 4c8d059e520000 418d5216 }
            // n = 7, score = 100
            //   4181f9000000c0       | jne                 0x393
            //   7532                 | dec                 eax
            //   4585d2               | cmp                 dword ptr [esp + 0x40], 8
            //   756e                 | dec                 ecx
            //   488d4b04             | mov                 ecx, esp
            //   4c8d059e520000       | dec                 ecx
            //   418d5216             | mov                 ecx, ebp

        $sequence_6 = { 4883ec20 33c0 48c7411807000000 488d15a97d0200 48894110 4983c9ff 4533c0 }
            // n = 7, score = 100
            //   4883ec20             | dec                 esp
            //   33c0                 | lea                 eax, [esp + 0x70]
            //   48c7411807000000     | dec                 ecx
            //   488d15a97d0200       | mov                 edx, esp
            //   48894110             | dec                 eax
            //   4983c9ff             | mov                 ecx, ebx
            //   4533c0               | cmp                 word ptr [eax], 0

        $sequence_7 = { c78534590000c1ba3099 c785385900002c7b2848 c7853c590000a1d91b85 c78540590000ea4058b5 c78544590000e6ecbf88 66c7854859000094a8 e8???????? }
            // n = 7, score = 100
            //   c78534590000c1ba3099     | cmovo    eax, esp
            //   c785385900002c7b2848     | dec    eax
            //   c7853c590000a1d91b85     | mov    ecx, eax
            //   c78540590000ea4058b5     | dec    esp
            //   c78544590000e6ecbf88     | lea    eax, [ebp + 0x690]
            //   66c7854859000094a8     | dec    eax
            //   e8????????           |                     

        $sequence_8 = { e9???????? 488bcd e8???????? 48ffc3 4c8be8 e9???????? 48ff4548 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488bcd               | mov                 ebx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   48ffc3               | dec                 eax
            //   4c8be8               | add                 esp, 0x20
            //   e9????????           |                     
            //   48ff4548             | dec                 eax

        $sequence_9 = { c744246c3ffbe9ea c7442470f94bc72d c7442474d9ec5e31 c7442478b1fab2fb c744247c3ecc0cc2 c74580af6c9d01 c74584614a63ca }
            // n = 7, score = 100
            //   c744246c3ffbe9ea     | dec                 eax
            //   c7442470f94bc72d     | lea                 edx, [esp + 0x44]
            //   c7442474d9ec5e31     | inc                 ebp
            //   c7442478b1fab2fb     | xor                 ecx, ecx
            //   c744247c3ecc0cc2     | inc                 ebp
            //   c74580af6c9d01       | xor                 eax, eax
            //   c74584614a63ca       | mov                 edx, 0x8004

    condition:
        7 of them and filesize < 409600
}