rule win_rokrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rokrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rokrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 6a18 33c0 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a18                 | push                0x18
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 50 e8???????? 6a10 33c0 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 50 e8???????? 8d4568 8d4e60 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4568               | lea                 eax, [ebp + 0x68]
            //   8d4e60               | lea                 ecx, [esi + 0x60]

        $sequence_3 = { 6a00 50 8bcb e8???????? 8d4550 }
            // n = 5, score = 700
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8d4550               | lea                 eax, [ebp + 0x50]

        $sequence_4 = { 668945d8 e8???????? c645fc03 8b45bc }
            // n = 4, score = 700
            //   668945d8             | mov                 word ptr [ebp - 0x28], ax
            //   e8????????           |                     
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]

        $sequence_5 = { 0fb7c1 50 0fb74208 c1e910 51 50 0fb74212 }
            // n = 7, score = 700
            //   0fb7c1               | movzx               eax, cx
            //   50                   | push                eax
            //   0fb74208             | movzx               eax, word ptr [edx + 8]
            //   c1e910               | shr                 ecx, 0x10
            //   51                   | push                ecx
            //   50                   | push                eax
            //   0fb74212             | movzx               eax, word ptr [edx + 0x12]

        $sequence_6 = { 56 50 8d45f4 64a300000000 c745fc00000000 33c0 }
            // n = 6, score = 700
            //   56                   | push                esi
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   33c0                 | xor                 eax, eax

        $sequence_7 = { 50 ff15???????? e8???????? 40 }
            // n = 4, score = 700
            //   50                   | push                eax
            //   ff15????????         |                     
            //   e8????????           |                     
            //   40                   | inc                 eax

        $sequence_8 = { 50 8bcf e8???????? 8d4538 3bd8 }
            // n = 5, score = 700
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8d4538               | lea                 eax, [ebp + 0x38]
            //   3bd8                 | cmp                 ebx, eax

        $sequence_9 = { ff15???????? 50 e8???????? 59 6a64 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a64                 | push                0x64

        $sequence_10 = { 897dfc e8???????? 68???????? 8d4dd8 e8???????? }
            // n = 5, score = 200
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   e8????????           |                     

        $sequence_11 = { c1e004 8b44100c 5d 5b }
            // n = 4, score = 100
            //   c1e004               | shl                 eax, 4
            //   8b44100c             | mov                 eax, dword ptr [eax + edx + 0xc]
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_12 = { c1e006 03048dc03b5500 eb02 8bc2 }
            // n = 4, score = 100
            //   c1e006               | shl                 eax, 6
            //   03048dc03b5500       | add                 eax, dword ptr [ecx*4 + 0x553bc0]
            //   eb02                 | jmp                 4
            //   8bc2                 | mov                 eax, edx

        $sequence_13 = { c1e004 8b441008 85c0 7418 }
            // n = 4, score = 100
            //   c1e004               | shl                 eax, 4
            //   8b441008             | mov                 eax, dword ptr [eax + edx + 8]
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a

        $sequence_14 = { c1e004 8b441004 8d5001 8a08 40 }
            // n = 5, score = 100
            //   c1e004               | shl                 eax, 4
            //   8b441004             | mov                 eax, dword ptr [eax + edx + 4]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax

        $sequence_15 = { c1e004 8d0c10 51 e8???????? }
            // n = 4, score = 100
            //   c1e004               | shl                 eax, 4
            //   8d0c10               | lea                 ecx, [eax + edx]
            //   51                   | push                ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2932736
}