rule win_safenet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.safenet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.safenet"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837dec00 7405 ff75ec ff16 837de800 7405 }
            // n = 6, score = 100
            //   837dec00             | cmp                 dword ptr [ebp - 0x14], 0
            //   7405                 | je                  7
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff16                 | call                dword ptr [esi]
            //   837de800             | cmp                 dword ptr [ebp - 0x18], 0
            //   7405                 | je                  7

        $sequence_1 = { 6a01 5b 33f6 663bc6 7437 663d2200 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   5b                   | pop                 ebx
            //   33f6                 | xor                 esi, esi
            //   663bc6               | cmp                 ax, si
            //   7437                 | je                  0x39
            //   663d2200             | cmp                 ax, 0x22

        $sequence_2 = { 8d4de8 e8???????? 6a01 8d4dd0 e8???????? eb0e e8???????? }
            // n = 7, score = 100
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]
            //   e8????????           |                     
            //   eb0e                 | jmp                 0x10
            //   e8????????           |                     

        $sequence_3 = { 75dc 8901 ebf3 56 }
            // n = 4, score = 100
            //   75dc                 | jne                 0xffffffde
            //   8901                 | mov                 dword ptr [ecx], eax
            //   ebf3                 | jmp                 0xfffffff5
            //   56                   | push                esi

        $sequence_4 = { 56 6a01 68000000c0 ff7514 ff15???????? }
            // n = 5, score = 100
            //   56                   | push                esi
            //   6a01                 | push                1
            //   68000000c0           | push                0xc0000000
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff15????????         |                     

        $sequence_5 = { 397de4 0f85dc020000 ff15???????? 0fb6c8 33d2 }
            // n = 5, score = 100
            //   397de4               | cmp                 dword ptr [ebp - 0x1c], edi
            //   0f85dc020000         | jne                 0x2e2
            //   ff15????????         |                     
            //   0fb6c8               | movzx               ecx, al
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { 754e 83602000 8b7604 e9???????? 8b4808 397920 7518 }
            // n = 7, score = 100
            //   754e                 | jne                 0x50
            //   83602000             | and                 dword ptr [eax + 0x20], 0
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   e9????????           |                     
            //   8b4808               | mov                 ecx, dword ptr [eax + 8]
            //   397920               | cmp                 dword ptr [ecx + 0x20], edi
            //   7518                 | jne                 0x1a

        $sequence_7 = { 85c0 7509 837df801 0f94c0 8bf8 ff75fc ff15???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   837df801             | cmp                 dword ptr [ebp - 8], 1
            //   0f94c0               | sete                al
            //   8bf8                 | mov                 edi, eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_8 = { 2bd1 8d34b5d8d84000 832600 83c60c 4a }
            // n = 5, score = 100
            //   2bd1                 | sub                 edx, ecx
            //   8d34b5d8d84000       | lea                 esi, [esi*4 + 0x40d8d8]
            //   832600               | and                 dword ptr [esi], 0
            //   83c60c               | add                 esi, 0xc
            //   4a                   | dec                 edx

        $sequence_9 = { 8dbd7cffffff 59 f3ab 8b462c 33ff 3bc7 c7857cffffff24000000 }
            // n = 7, score = 100
            //   8dbd7cffffff         | lea                 edi, [ebp - 0x84]
            //   59                   | pop                 ecx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]
            //   33ff                 | xor                 edi, edi
            //   3bc7                 | cmp                 eax, edi
            //   c7857cffffff24000000     | mov    dword ptr [ebp - 0x84], 0x24

    condition:
        7 of them and filesize < 262144
}