rule win_scarabey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.scarabey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scarabey"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 8d95b8d2ffff 52 ff15???????? 6a00 6a00 6a01 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   8d95b8d2ffff         | lea                 edx, [ebp - 0x2d48]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_1 = { 52 ff15???????? 68ff000000 6a02 53 895c2450 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   68ff000000           | push                0xff
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx

        $sequence_2 = { 53 6a00 56 8985ecd6ffff ffd7 83fb01 0f8410010000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8985ecd6ffff         | mov                 dword ptr [ebp - 0x2914], eax
            //   ffd7                 | call                edi
            //   83fb01               | cmp                 ebx, 1
            //   0f8410010000         | je                  0x116

        $sequence_3 = { 8d8504e7ffff 50 c78504e7ffff94000000 ff15???????? 6a01 }
            // n = 5, score = 100
            //   8d8504e7ffff         | lea                 eax, [ebp - 0x18fc]
            //   50                   | push                eax
            //   c78504e7ffff94000000     | mov    dword ptr [ebp - 0x18fc], 0x94
            //   ff15????????         |                     
            //   6a01                 | push                1

        $sequence_4 = { ff15???????? 8d4c2410 51 8bce e8???????? 6a0f }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   6a0f                 | push                0xf

        $sequence_5 = { 7d04 8944241c 686666aa00 50 33db 6a02 895c2450 }
            // n = 7, score = 100
            //   7d04                 | jge                 6
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   686666aa00           | push                0xaa6666
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   6a02                 | push                2
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx

        $sequence_6 = { 50 c78504e7ffff94000000 ff15???????? 6a01 8d8d54d2ffff 51 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c78504e7ffff94000000     | mov    dword ptr [ebp - 0x18fc], 0x94
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8d8d54d2ffff         | lea                 ecx, [ebp - 0x2dac]
            //   51                   | push                ecx

        $sequence_7 = { 895c2450 c744244c68025300 ff15???????? 50 8d4c2444 e8???????? 8b442444 }
            // n = 7, score = 100
            //   895c2450             | mov                 dword ptr [esp + 0x50], ebx
            //   c744244c68025300     | mov                 dword ptr [esp + 0x4c], 0x530268
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d4c2444             | lea                 ecx, [esp + 0x44]
            //   e8????????           |                     
            //   8b442444             | mov                 eax, dword ptr [esp + 0x44]

        $sequence_8 = { 3d01010000 7d0d 8a4c181c 8888f0b15700 40 ebe9 33c0 }
            // n = 7, score = 100
            //   3d01010000           | cmp                 eax, 0x101
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   8888f0b15700         | mov                 byte ptr [eax + 0x57b1f0], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { e8???????? 834dfcff 8d4dd4 c745d480185300 e8???????? e8???????? c3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   c745d480185300       | mov                 dword ptr [ebp - 0x2c], 0x531880
            //   e8????????           |                     
            //   e8????????           |                     
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 3580928
}