rule win_sendsafe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sendsafe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sendsafe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d08 8988a8000000 8b55fc 83c244 52 ff15???????? 6a02 }
            // n = 7, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8988a8000000         | mov                 dword ptr [eax + 0xa8], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c244               | add                 edx, 0x44
            //   52                   | push                edx
            //   ff15????????         |                     
            //   6a02                 | push                2

        $sequence_1 = { c7804c03000000000000 8b4608 ff742428 8b4864 8b86c0000000 83c014 50 }
            // n = 7, score = 200
            //   c7804c03000000000000     | mov    dword ptr [eax + 0x34c], 0
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   8b4864               | mov                 ecx, dword ptr [eax + 0x64]
            //   8b86c0000000         | mov                 eax, dword ptr [esi + 0xc0]
            //   83c014               | add                 eax, 0x14
            //   50                   | push                eax

        $sequence_2 = { ff7508 e8???????? 8b4df4 83c410 8b0c8d90945b00 89441928 8b45f0 }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   83c410               | add                 esp, 0x10
            //   8b0c8d90945b00       | mov                 ecx, dword ptr [ecx*4 + 0x5b9490]
            //   89441928             | mov                 dword ptr [ecx + ebx + 0x28], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_3 = { ebcc 8b55e8 2355bc 8b4514 8d0cd0 894de4 8b55e4 }
            // n = 7, score = 200
            //   ebcc                 | jmp                 0xffffffce
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   2355bc               | and                 edx, dword ptr [ebp - 0x44]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8d0cd0               | lea                 ecx, [eax + edx*8]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_4 = { e9???????? 8b4dec 8b11 899578ffffff 8b45ec 50 8b8d78ffffff }
            // n = 7, score = 200
            //   e9????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   899578ffffff         | mov                 dword ptr [ebp - 0x88], edx
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   8b8d78ffffff         | mov                 ecx, dword ptr [ebp - 0x88]

        $sequence_5 = { ff742428 e8???????? 83c414 85c0 0f842a020000 8b4c241c b801000000 }
            // n = 7, score = 200
            //   ff742428             | push                dword ptr [esp + 0x28]
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   85c0                 | test                eax, eax
            //   0f842a020000         | je                  0x230
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   b801000000           | mov                 eax, 1

        $sequence_6 = { e8???????? 8b8540ffffff 8b8d44ffffff 8b9538ffffff 899481140a0000 8b8540ffffff 8b8d44ffffff }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b8540ffffff         | mov                 eax, dword ptr [ebp - 0xc0]
            //   8b8d44ffffff         | mov                 ecx, dword ptr [ebp - 0xbc]
            //   8b9538ffffff         | mov                 edx, dword ptr [ebp - 0xc8]
            //   899481140a0000       | mov                 dword ptr [ecx + eax*4 + 0xa14], edx
            //   8b8540ffffff         | mov                 eax, dword ptr [ebp - 0xc0]
            //   8b8d44ffffff         | mov                 ecx, dword ptr [ebp - 0xbc]

        $sequence_7 = { c7406cac1d5600 b807000000 e9???????? 837dfc00 742b b904000000 6bd10d }
            // n = 7, score = 200
            //   c7406cac1d5600       | mov                 dword ptr [eax + 0x6c], 0x561dac
            //   b807000000           | mov                 eax, 7
            //   e9????????           |                     
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   742b                 | je                  0x2d
            //   b904000000           | mov                 ecx, 4
            //   6bd10d               | imul                edx, ecx, 0xd

        $sequence_8 = { e8???????? 8bd8 83c414 84db 7912 c74424483b000000 b942020000 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   83c414               | add                 esp, 0x14
            //   84db                 | test                bl, bl
            //   7912                 | jns                 0x14
            //   c74424483b000000     | mov                 dword ptr [esp + 0x48], 0x3b
            //   b942020000           | mov                 ecx, 0x242

        $sequence_9 = { 8b8de4fbffff 8b95ecfbffff 031481 8995ecfbffff e9???????? eb54 8b85e8fbffff }
            // n = 7, score = 200
            //   8b8de4fbffff         | mov                 ecx, dword ptr [ebp - 0x41c]
            //   8b95ecfbffff         | mov                 edx, dword ptr [ebp - 0x414]
            //   031481               | add                 edx, dword ptr [ecx + eax*4]
            //   8995ecfbffff         | mov                 dword ptr [ebp - 0x414], edx
            //   e9????????           |                     
            //   eb54                 | jmp                 0x56
            //   8b85e8fbffff         | mov                 eax, dword ptr [ebp - 0x418]

    condition:
        7 of them and filesize < 3743744
}