rule win_sepsys_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sepsys."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sepsys"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c685fb00000000 8a4517 2401 88c1 e8???????? 884516 eb00 }
            // n = 7, score = 400
            //   c685fb00000000       | dec                 eax
            //   8a4517               | test                eax, eax
            //   2401                 | je                  0x1afe
            //   88c1                 | mov                 dword ptr [ebp - 0x48], ecx
            //   e8????????           |                     
            //   884516               | mov                 ecx, edx
            //   eb00                 | mov                 edx, dword ptr [ebp - 0x40]

        $sequence_1 = { e8???????? eb00 488b4db0 c645f700 488b45c8 488945e0 0f1045b8 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   eb00                 | or                  eax, dword ptr [esp + 0xd5c]
            //   488b4db0             | mov                 dword ptr [esp + 0xb30], eax
            //   c645f700             | mov                 ecx, dword ptr [esp + 0x1044]
            //   488b45c8             | or                  ecx, dword ptr [esp + 0x1124]
            //   488945e0             | mov                 edx, dword ptr [esp + 0x1048]
            //   0f1045b8             | or                  edx, dword ptr [esp + 0x1128]

        $sequence_2 = { e9???????? 4883bd9801000000 7714 eb09 c685df01000001 eb29 c685df01000000 }
            // n = 7, score = 400
            //   e9????????           |                     
            //   4883bd9801000000     | mov                 ecx, eax
            //   7714                 | test                eax, eax
            //   eb09                 | jne                 0x150d
            //   c685df01000001       | movsx               eax, byte ptr [esp + 0x20]
            //   eb29                 | cmp                 eax, 0x2b
            //   c685df01000000       | je                  0x150d

        $sequence_3 = { e8???????? 488b442428 488b4820 48894c2478 488b4828 48898c2480000000 488b4830 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   488b442428           | imul                ecx, ecx, 1
            //   488b4820             | dec                 eax
            //   48894c2478           | lea                 edx, [0xa3ef]
            //   488b4828             | dec                 eax
            //   48898c2480000000     | add                 edx, ecx
            //   488b4830             | dec                 eax

        $sequence_4 = { eb00 eb00 eb00 31c0 89c1 488b55f0 4881ea02000000 }
            // n = 7, score = 400
            //   eb00                 | mov                 edx, 2
            //   eb00                 | dec                 eax
            //   eb00                 | mov                 ecx, dword ptr [esp + 0x88]
            //   31c0                 | dec                 eax
            //   89c1                 | mov                 eax, dword ptr [esp + 0x2c0]
            //   488b55f0             | dec                 eax
            //   4881ea02000000       | mov                 eax, dword ptr [eax + 0x430]

        $sequence_5 = { 817c243448270000 7507 c644243001 eb05 c644243000 48837c245800 740b }
            // n = 7, score = 400
            //   817c243448270000     | test                byte ptr [ebp - 1], 1
            //   7507                 | je                  0x8fa
            //   c644243001           | push                esi
            //   eb05                 | push                edi
            //   c644243000           | push                ebx
            //   48837c245800         | dec                 eax
            //   740b                 | sub                 esp, 0x28

        $sequence_6 = { 83c804 89442420 8b442420 0fbaf008 89442420 e9???????? 8b442420 }
            // n = 7, score = 400
            //   83c804               | movdqa              xmm0, xmmword ptr [ebx + 0x8a40]
            //   89442420             | movdqa              xmm0, xmmword ptr [ebx + 0x2380]
            //   8b442420             | movdqa              xmmword ptr [ebx + 0x23d0], xmm0
            //   0fbaf008             | movdqa              xmm0, xmmword ptr [ebx + 0x23d0]
            //   89442420             | movdqa              xmmword ptr [ebx + 0xc10], xmm0
            //   e9????????           |                     
            //   8b442420             | dec                 eax

        $sequence_7 = { e8???????? 488d4518 488b4df8 48894de8 4889c1 488b55e8 4c8b45f0 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   488d4518             | dec                 eax
            //   488b4df8             | mov                 eax, dword ptr [ecx + eax]
            //   48894de8             | dec                 eax
            //   4889c1               | mov                 dword ptr [esp + 0x58], eax
            //   488b55e8             | mov                 eax, dword ptr [esp + 0x30]
            //   4c8b45f0             | dec                 eax

        $sequence_8 = { ebe9 488b45e0 4883c460 5d c3 f645f601 74f0 }
            // n = 7, score = 400
            //   ebe9                 | dec                 eax
            //   488b45e0             | mov                 eax, dword ptr [ebp - 0x20]
            //   4883c460             | dec                 eax
            //   5d                   | add                 eax, 8
            //   c3                   | dec                 eax
            //   f645f601             | lea                 edx, [0xf1d62]
            //   74f0                 | dec                 eax

        $sequence_9 = { c685b600000000 c685b400000000 e9???????? c685b400000000 488b4d28 488b5530 e8???????? }
            // n = 7, score = 400
            //   c685b600000000       | mov                 eax, dword ptr [esp + 0x88]
            //   c685b400000000       | dec                 eax
            //   e9????????           |                     
            //   c685b400000000       | mov                 dword ptr [eax + 0x218], 0
            //   488b4d28             | dec                 eax
            //   488b5530             | mov                 eax, dword ptr [esp + 0x88]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 4538368
}