rule win_shifu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.shifu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.shifu"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 32c0 8d7d9c 6a08 f3aa 58 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   32c0                 | xor                 al, al
            //   8d7d9c               | lea                 edi, [ebp - 0x64]
            //   6a08                 | push                8
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   58                   | pop                 eax
            //   e8????????           |                     

        $sequence_1 = { 50 8b470c 6a00 83c030 50 6a01 ffd3 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   6a00                 | push                0
            //   83c030               | add                 eax, 0x30
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ffd3                 | call                ebx

        $sequence_2 = { 83c8ff ebf0 55 8bec eb0a 8b4d08 48 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   ebf0                 | jmp                 0xfffffff2
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   eb0a                 | jmp                 0xc
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   48                   | dec                 eax

        $sequence_3 = { 8bc4 85c0 7411 6894000000 6a0b ba???????? e8???????? }
            // n = 7, score = 100
            //   8bc4                 | mov                 eax, esp
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   6894000000           | push                0x94
            //   6a0b                 | push                0xb
            //   ba????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 6a0c 5e e8???????? 8945f8 3bc7 0f847d030000 897808 }
            // n = 7, score = 100
            //   6a0c                 | push                0xc
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   3bc7                 | cmp                 eax, edi
            //   0f847d030000         | je                  0x383
            //   897808               | mov                 dword ptr [eax + 8], edi

        $sequence_5 = { 83e203 c1e204 c1eb04 0bd3 8a1402 885601 }
            // n = 6, score = 100
            //   83e203               | and                 edx, 3
            //   c1e204               | shl                 edx, 4
            //   c1eb04               | shr                 ebx, 4
            //   0bd3                 | or                  edx, ebx
            //   8a1402               | mov                 dl, byte ptr [edx + eax]
            //   885601               | mov                 byte ptr [esi + 1], dl

        $sequence_6 = { e8???????? 8bc4 85c0 7411 6889000000 6a0a }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bc4                 | mov                 eax, esp
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   6889000000           | push                0x89
            //   6a0a                 | push                0xa

        $sequence_7 = { c645ff01 eb4a 807dff00 740f 8bf3 e8???????? 85c0 }
            // n = 7, score = 100
            //   c645ff01             | mov                 byte ptr [ebp - 1], 1
            //   eb4a                 | jmp                 0x4c
            //   807dff00             | cmp                 byte ptr [ebp - 1], 0
            //   740f                 | je                  0x11
            //   8bf3                 | mov                 esi, ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 8bc4 85c0 7411 6882000000 6a0b ba???????? e8???????? }
            // n = 7, score = 100
            //   8bc4                 | mov                 eax, esp
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13
            //   6882000000           | push                0x82
            //   6a0b                 | push                0xb
            //   ba????????           |                     
            //   e8????????           |                     

        $sequence_9 = { d1e8 8bf0 eb05 85db 7401 4b 83fb01 }
            // n = 7, score = 100
            //   d1e8                 | shr                 eax, 1
            //   8bf0                 | mov                 esi, eax
            //   eb05                 | jmp                 7
            //   85db                 | test                ebx, ebx
            //   7401                 | je                  3
            //   4b                   | dec                 ebx
            //   83fb01               | cmp                 ebx, 1

    condition:
        7 of them and filesize < 344064
}