rule win_slingshot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.slingshot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.slingshot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 33db 53 ff15???????? 8bf0 3bf3 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   3bf3                 | cmp                 esi, ebx

        $sequence_1 = { 742f 44 8bc5 48 }
            // n = 4, score = 100
            //   742f                 | je                  0x31
            //   44                   | inc                 esp
            //   8bc5                 | mov                 eax, ebp
            //   48                   | dec                 eax

        $sequence_2 = { 41 ffc3 44 895c2420 e9???????? }
            // n = 5, score = 100
            //   41                   | inc                 ecx
            //   ffc3                 | inc                 ebx
            //   44                   | inc                 esp
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   e9????????           |                     

        $sequence_3 = { 57 ff742408 50 e8???????? 013e 33c0 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   ff742408             | push                dword ptr [esp + 8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   013e                 | add                 dword ptr [esi], edi
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 8bf1 33ff 48 893d???????? }
            // n = 4, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   33ff                 | xor                 edi, edi
            //   48                   | dec                 eax
            //   893d????????         |                     

        $sequence_5 = { 3bcb 7512 ff7708 ff37 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   7512                 | jne                 0x14
            //   ff7708               | push                dword ptr [edi + 8]
            //   ff37                 | push                dword ptr [edi]

        $sequence_6 = { 215110 4d 8b4108 41 8b11 e8???????? 48 }
            // n = 7, score = 100
            //   215110               | and                 dword ptr [ecx + 0x10], edx
            //   4d                   | dec                 ebp
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   41                   | inc                 ecx
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   e8????????           |                     
            //   48                   | dec                 eax

        $sequence_7 = { 8d1587960000 48 8bc8 ff15???????? 48 8905???????? }
            // n = 6, score = 100
            //   8d1587960000         | lea                 edx, [0x9687]
            //   48                   | dec                 eax
            //   8bc8                 | mov                 ecx, eax
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8905????????         |                     

        $sequence_8 = { 3bcb 7504 6a08 eb7a }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   7504                 | jne                 6
            //   6a08                 | push                8
            //   eb7a                 | jmp                 0x7c

        $sequence_9 = { 3bcb 7442 395dfc 7414 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   7442                 | je                  0x44
            //   395dfc               | cmp                 dword ptr [ebp - 4], ebx
            //   7414                 | je                  0x16

        $sequence_10 = { c3 837e0c00 760f 8b4604 85c0 7408 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   837e0c00             | cmp                 dword ptr [esi + 0xc], 0
            //   760f                 | jbe                 0x11
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa

        $sequence_11 = { 3bcb 755c 8b4e10 33d2 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   755c                 | jne                 0x5e
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   33d2                 | xor                 edx, edx

        $sequence_12 = { 8bcf 4d 8bc4 33d2 }
            // n = 4, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   4d                   | dec                 ebp
            //   8bc4                 | mov                 eax, esp
            //   33d2                 | xor                 edx, edx

        $sequence_13 = { 8901 8b45d4 3bc2 8903 }
            // n = 4, score = 100
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   3bc2                 | cmp                 eax, edx
            //   8903                 | mov                 dword ptr [ebx], eax

        $sequence_14 = { 41 43 4e ff4c2418 47 85f6 75e6 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   43                   | inc                 ebx
            //   4e                   | dec                 esi
            //   ff4c2418             | dec                 dword ptr [esp + 0x18]
            //   47                   | inc                 edi
            //   85f6                 | test                esi, esi
            //   75e6                 | jne                 0xffffffe8

        $sequence_15 = { 3bcb 7461 8b01 83f807 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   7461                 | je                  0x63
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   83f807               | cmp                 eax, 7

        $sequence_16 = { 85c0 7461 68090000cf 8d4c242c 8d44245c e8???????? 8b18 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7461                 | je                  0x63
            //   68090000cf           | push                0xcf000009
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   8d44245c             | lea                 eax, [esp + 0x5c]
            //   e8????????           |                     
            //   8b18                 | mov                 ebx, dword ptr [eax]

        $sequence_17 = { 3bcb 7552 dd45f0 dd4720 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   7552                 | jne                 0x54
            //   dd45f0               | fld                 qword ptr [ebp - 0x10]
            //   dd4720               | fld                 qword ptr [edi + 0x20]

        $sequence_18 = { ff15???????? 48 8b4c2430 49 bb0080c12a }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   49                   | dec                 ecx
            //   bb0080c12a           | mov                 ebx, 0x2ac18000

        $sequence_19 = { 41 8d4101 0fb6f0 8b54b708 42 8d0412 44 }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   8d4101               | lea                 eax, [ecx + 1]
            //   0fb6f0               | movzx               esi, al
            //   8b54b708             | mov                 edx, dword ptr [edi + esi*4 + 8]
            //   42                   | inc                 edx
            //   8d0412               | lea                 eax, [edx + edx]
            //   44                   | inc                 esp

        $sequence_20 = { 894a34 8b480c 3bcf 7425 397808 7420 8b7228 }
            // n = 7, score = 100
            //   894a34               | mov                 dword ptr [edx + 0x34], ecx
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   3bcf                 | cmp                 ecx, edi
            //   7425                 | je                  0x27
            //   397808               | cmp                 dword ptr [eax + 8], edi
            //   7420                 | je                  0x22
            //   8b7228               | mov                 esi, dword ptr [edx + 0x28]

        $sequence_21 = { c9 c3 57 e8???????? 833d????????00 }
            // n = 5, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   57                   | push                edi
            //   e8????????           |                     
            //   833d????????00       |                     

        $sequence_22 = { 3bcb 753c ff7708 eb28 }
            // n = 4, score = 100
            //   3bcb                 | cmp                 ecx, ebx
            //   753c                 | jne                 0x3e
            //   ff7708               | push                dword ptr [edi + 8]
            //   eb28                 | jmp                 0x2a

    condition:
        7 of them and filesize < 663552
}