rule win_spica_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.spica."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spica"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8d8c040000 898df0000000 488b8d58040000 898df4000000 488b8de8030000 48898df8000000 4889b5c8000000 }
            // n = 7, score = 100
            //   8b8d8c040000         | dec                 eax
            //   898df0000000         | lea                 ecx, [ebp - 0x60]
            //   488b8d58040000       | dec                 eax
            //   898df4000000         | mov                 edx, edi
            //   488b8de8030000       | dec                 ecx
            //   48898df8000000       | mov                 eax, esi
            //   4889b5c8000000       | mov                 eax, dword ptr [ebp + 0x170]

        $sequence_1 = { e9???????? c6850708000001 c6850608000001 c6850508000001 488d05f0a93100 4889442420 488d0d046e3a00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   c6850708000001       | mov                 esi, dword ptr [esp + 0xa0]
            //   c6850608000001       | cmp                 byte ptr [ebx + 1], 0
            //   c6850508000001       | je                  0x491
            //   488d05f0a93100       | dec                 eax
            //   4889442420           | lea                 eax, [0x455998]
            //   488d0d046e3a00       | dec                 eax

        $sequence_2 = { eb08 498bc8 e8???????? 0fb64354 2c01 884354 7594 }
            // n = 7, score = 100
            //   eb08                 | jmp                 0xd8b
            //   498bc8               | dec                 eax
            //   e8????????           |                     
            //   0fb64354             | mov                 ebx, dword ptr [ebp + 0x10]
            //   2c01                 | dec                 esp
            //   884354               | mov                 dword ptr [esp + 0x50], ebp
            //   7594                 | dec                 eax

        $sequence_3 = { e9???????? 488b5710 4883c710 4885d2 0f8553ffffff eba4 418b7f10 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b5710             | dec                 eax
            //   4883c710             | mov                 ecx, ebp
            //   4885d2               | dec                 eax
            //   0f8553ffffff         | mov                 edx, dword ptr [edx + 0x10]
            //   eba4                 | dec                 eax
            //   418b7f10             | mov                 ecx, ebp

        $sequence_4 = { e8???????? 410fb68539010000 4c8b4f08 488b9500060000 488b4a60 488b5270 88442470 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   410fb68539010000     | inc                 ecx
            //   4c8b4f08             | mov                 ecx, esi
            //   488b9500060000       | inc                 eax
            //   488b4a60             | or                  dh, al
            //   488b5270             | dec                 ecx
            //   88442470             | lea                 edx, [edi + 0x20]

        $sequence_5 = { 84db 7536 488b05???????? 48c1e001 4885c0 7426 e9???????? }
            // n = 7, score = 100
            //   84db                 | dec                 eax
            //   7536                 | lea                 edx, [0x34f254]
            //   488b05????????       |                     
            //   48c1e001             | dec                 eax
            //   4885c0               | cmove               edx, eax
            //   7426                 | movzx               eax, bl
            //   e9????????           |                     

        $sequence_6 = { ffcb 4883c720 85db 7fde 498b5740 4885d2 7410 }
            // n = 7, score = 100
            //   ffcb                 | lea                 ecx, [eax + eax*2]
            //   4883c720             | dec                 eax
            //   85db                 | mov                 eax, dword ptr [edi + 0x88]
            //   7fde                 | dec                 eax
            //   498b5740             | lea                 edx, [eax + ecx*8]
            //   4885d2               | inc                 ebp
            //   7410                 | test                ecx, ecx

        $sequence_7 = { eb28 48895d50 b908000000 ba10000000 e8???????? eb13 48895d50 }
            // n = 7, score = 100
            //   eb28                 | cmp                 eax, 0xa029a697
            //   48895d50             | je                  0x17b
            //   b908000000           | cmp                 eax, 0x4b771290
            //   ba10000000           | je                  0x12e
            //   e8????????           |                     
            //   eb13                 | dec                 esp
            //   48895d50             | lea                 eax, [0x202cea]

        $sequence_8 = { e9???????? 4d89dc 4c89d9 4889fa e8???????? 84c0 0f842f010000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4d89dc               | mov                 dword ptr [ebp + 0xb90], esp
            //   4c89d9               | dec                 eax
            //   4889fa               | mov                 eax, dword ptr [ebp + 0xb80]
            //   e8????????           |                     
            //   84c0                 | dec                 eax
            //   0f842f010000         | mov                 dword ptr [ebp + 0xb88], eax

        $sequence_9 = { e9???????? 4983c303 eb3e b80e000000 e9???????? 4983c304 eb2e }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4983c303             | lea                 ecx, [esp + 0x40]
            //   eb3e                 | dec                 eax
            //   b80e000000           | mov                 edx, dword ptr [esp + 0x38]
            //   e9????????           |                     
            //   4983c304             | inc                 ecx
            //   eb2e                 | mov                 eax, ebp

    condition:
        7 of them and filesize < 14034944
}