rule win_spora_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.spora_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spora_ransom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebe9 b005 ebe5 b006 ebe1 }
            // n = 5, score = 200
            //   ebe9                 | jmp                 0xffffffeb
            //   b005                 | mov                 al, 5
            //   ebe5                 | jmp                 0xffffffe7
            //   b006                 | mov                 al, 6
            //   ebe1                 | jmp                 0xffffffe3

        $sequence_1 = { 85c0 7436 03fb 83ff0c 72ec 33ff }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7436                 | je                  0x38
            //   03fb                 | add                 edi, ebx
            //   83ff0c               | cmp                 edi, 0xc
            //   72ec                 | jb                  0xffffffee
            //   33ff                 | xor                 edi, edi

        $sequence_2 = { f6c301 742c 6a3a 8d4641 668945f0 58 ff7510 }
            // n = 7, score = 200
            //   f6c301               | test                bl, 1
            //   742c                 | je                  0x2e
            //   6a3a                 | push                0x3a
            //   8d4641               | lea                 eax, [esi + 0x41]
            //   668945f0             | mov                 word ptr [ebp - 0x10], ax
            //   58                   | pop                 eax
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_3 = { 75b4 8b7df4 57 ff15???????? ff75fc e8???????? }
            // n = 6, score = 200
            //   75b4                 | jne                 0xffffffb6
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_4 = { 740e 8b45fc 8b4010 0fb6f0 }
            // n = 4, score = 200
            //   740e                 | je                  0x10
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   0fb6f0               | movzx               esi, al

        $sequence_5 = { 56 6a19 ff75f8 ff15???????? 85c0 7425 837dfc00 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   6a19                 | push                0x19
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0

        $sequence_6 = { ebf5 b002 ebf1 b003 ebed }
            // n = 5, score = 200
            //   ebf5                 | jmp                 0xfffffff7
            //   b002                 | mov                 al, 2
            //   ebf1                 | jmp                 0xfffffff3
            //   b003                 | mov                 al, 3
            //   ebed                 | jmp                 0xffffffef

        $sequence_7 = { 85c0 7466 56 57 bf00020000 }
            // n = 5, score = 200
            //   85c0                 | test                eax, eax
            //   7466                 | je                  0x68
            //   56                   | push                esi
            //   57                   | push                edi
            //   bf00020000           | mov                 edi, 0x200

        $sequence_8 = { 8d440010 50 6a40 ffd3 8bf8 85ff 7416 }
            // n = 7, score = 200
            //   8d440010             | lea                 eax, [eax + eax + 0x10]
            //   50                   | push                eax
            //   6a40                 | push                0x40
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7416                 | je                  0x18

        $sequence_9 = { 8bf8 85ff 7416 ff36 }
            // n = 4, score = 200
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7416                 | je                  0x18
            //   ff36                 | push                dword ptr [esi]

    condition:
        7 of them and filesize < 73728
}