rule win_stop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 8b4b04 b8abaaaa2a 2b0b f7e9 8bcf }
            // n = 7, score = 600
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   2b0b                 | sub                 ecx, dword ptr [ebx]
            //   f7e9                 | imul                ecx
            //   8bcf                 | mov                 ecx, edi

        $sequence_1 = { ff15???????? 8b35???????? 8b3d???????? 6a01 6a00 6a00 6a00 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8b3d????????         |                     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { ffd7 6a01 6a00 6a00 6a00 8d45e0 50 }
            // n = 7, score = 600
            //   ffd7                 | call                edi
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_3 = { 50 ffd6 85c0 75e8 6a0a ff7304 ff15???????? }
            // n = 7, score = 600
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e8                 | jne                 0xffffffea
            //   6a0a                 | push                0xa
            //   ff7304               | push                dword ptr [ebx + 4]
            //   ff15????????         |                     

        $sequence_4 = { 83c404 8b4b04 b8abaaaa2a 2b0b }
            // n = 4, score = 600
            //   83c404               | add                 esp, 4
            //   8b4b04               | mov                 ecx, dword ptr [ebx + 4]
            //   b8abaaaa2a           | mov                 eax, 0x2aaaaaab
            //   2b0b                 | sub                 ecx, dword ptr [ebx]

        $sequence_5 = { ffd6 85c0 75e2 5f }
            // n = 4, score = 600
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e2                 | jne                 0xffffffe4
            //   5f                   | pop                 edi

        $sequence_6 = { 83c102 eb84 6a0c 68???????? e8???????? 8b7d08 33c9 }
            // n = 7, score = 600
            //   83c102               | add                 ecx, 2
            //   eb84                 | jmp                 0xffffff86
            //   6a0c                 | push                0xc
            //   68????????           |                     
            //   e8????????           |                     
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33c9                 | xor                 ecx, ecx

        $sequence_7 = { 6a00 6a00 8d45e0 50 ffd6 85c0 741e }
            // n = 7, score = 600
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   741e                 | je                  0x20

        $sequence_8 = { 57 6a00 8bd9 6a00 6a12 ff33 ff15???????? }
            // n = 7, score = 600
            //   57                   | push                edi
            //   6a00                 | push                0
            //   8bd9                 | mov                 ebx, ecx
            //   6a00                 | push                0
            //   6a12                 | push                0x12
            //   ff33                 | push                dword ptr [ebx]
            //   ff15????????         |                     

        $sequence_9 = { 75e8 6a0a ff7304 ff15???????? 3d02010000 74c4 }
            // n = 6, score = 600
            //   75e8                 | jne                 0xffffffea
            //   6a0a                 | push                0xa
            //   ff7304               | push                dword ptr [ebx + 4]
            //   ff15????????         |                     
            //   3d02010000           | cmp                 eax, 0x102
            //   74c4                 | je                  0xffffffc6

    condition:
        7 of them and filesize < 6029312
}