rule win_stormwind_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stormwind."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stormwind"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff5004 8b36 3b37 75eb 68f4010000 8d4708 }
            // n = 6, score = 100
            //   ff5004               | call                dword ptr [eax + 4]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   3b37                 | cmp                 esi, dword ptr [edi]
            //   75eb                 | jne                 0xffffffed
            //   68f4010000           | push                0x1f4
            //   8d4708               | lea                 eax, [edi + 8]

        $sequence_1 = { f30f6f40e0 660ff9c1 f30f7f4407e0 3b55f4 7cd5 8b7df0 3bd6 }
            // n = 7, score = 100
            //   f30f6f40e0           | movdqu              xmm0, xmmword ptr [eax - 0x20]
            //   660ff9c1             | psubw               xmm0, xmm1
            //   f30f7f4407e0         | movdqu              xmmword ptr [edi + eax - 0x20], xmm0
            //   3b55f4               | cmp                 edx, dword ptr [ebp - 0xc]
            //   7cd5                 | jl                  0xffffffd7
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   3bd6                 | cmp                 edx, esi

        $sequence_2 = { 83c40c eb02 33ff ff7508 }
            // n = 4, score = 100
            //   83c40c               | add                 esp, 0xc
            //   eb02                 | jmp                 4
            //   33ff                 | xor                 edi, edi
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 6a00 8906 e8???????? 8945d0 8d45d0 50 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8906                 | mov                 dword ptr [esi], eax
            //   e8????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax

        $sequence_4 = { c20400 55 8bec 668b4d0e baf07f0000 668bc1 }
            // n = 6, score = 100
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   668b4d0e             | mov                 cx, word ptr [ebp + 0xe]
            //   baf07f0000           | mov                 edx, 0x7ff0
            //   668bc1               | mov                 ax, cx

        $sequence_5 = { e8???????? 8d4df0 83c404 3bc8 7408 8b30 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   83c404               | add                 esp, 4
            //   3bc8                 | cmp                 ecx, eax
            //   7408                 | je                  0xa
            //   8b30                 | mov                 esi, dword ptr [eax]

        $sequence_6 = { 4a 8955fc 81fa00010000 7309 0fb6b2e0f90310 eb0c 8bca }
            // n = 7, score = 100
            //   4a                   | dec                 edx
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   81fa00010000         | cmp                 edx, 0x100
            //   7309                 | jae                 0xb
            //   0fb6b2e0f90310       | movzx               esi, byte ptr [edx + 0x1003f9e0]
            //   eb0c                 | jmp                 0xe
            //   8bca                 | mov                 ecx, edx

        $sequence_7 = { 64a300000000 8bf9 897c241c 8b471c 8b08 }
            // n = 5, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   897c241c             | mov                 dword ptr [esp + 0x1c], edi
            //   8b471c               | mov                 eax, dword ptr [edi + 0x1c]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_8 = { 85db 7410 ff75e8 6a00 53 e8???????? }
            // n = 6, score = 100
            //   85db                 | test                ebx, ebx
            //   7410                 | je                  0x12
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_9 = { 8d45f4 64a300000000 8bf9 8d4dec c745e400000000 e8???????? c745fc00000000 }
            // n = 7, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8bf9                 | mov                 edi, ecx
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   e8????????           |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

    condition:
        7 of them and filesize < 741376
}