rule win_suncrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.suncrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.suncrypt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 75f3 56 8b35???????? ffd6 ff75bc ffd6 ff75b8 }
            // n = 7, score = 200
            //   75f3                 | jne                 0xfffffff5
            //   56                   | push                esi
            //   8b35????????         |                     
            //   ffd6                 | call                esi
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   ffd6                 | call                esi
            //   ff75b8               | push                dword ptr [ebp - 0x48]

        $sequence_1 = { 837dfc00 c745cc00000000 0f86c9020000 8975d8 f6460c02 }
            // n = 5, score = 200
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   c745cc00000000       | mov                 dword ptr [ebp - 0x34], 0
            //   0f86c9020000         | jbe                 0x2cf
            //   8975d8               | mov                 dword ptr [ebp - 0x28], esi
            //   f6460c02             | test                byte ptr [esi + 0xc], 2

        $sequence_2 = { ffd7 6808020000 6a00 68???????? a3???????? e8???????? 83c40c }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   6808020000           | push                0x208
            //   6a00                 | push                0
            //   68????????           |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 51 68???????? ffd3 3bc6 75db 3bd7 75d7 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   68????????           |                     
            //   ffd3                 | call                ebx
            //   3bc6                 | cmp                 eax, esi
            //   75db                 | jne                 0xffffffdd
            //   3bd7                 | cmp                 edx, edi
            //   75d7                 | jne                 0xffffffd9

        $sequence_4 = { c6857efeffff6d c6857ffeffff69 c68580feffff3a c68581feffff54 c68582feffff4e c68583feffff3a c68584feffff2b }
            // n = 7, score = 200
            //   c6857efeffff6d       | mov                 byte ptr [ebp - 0x182], 0x6d
            //   c6857ffeffff69       | mov                 byte ptr [ebp - 0x181], 0x69
            //   c68580feffff3a       | mov                 byte ptr [ebp - 0x180], 0x3a
            //   c68581feffff54       | mov                 byte ptr [ebp - 0x17f], 0x54
            //   c68582feffff4e       | mov                 byte ptr [ebp - 0x17e], 0x4e
            //   c68583feffff3a       | mov                 byte ptr [ebp - 0x17d], 0x3a
            //   c68584feffff2b       | mov                 byte ptr [ebp - 0x17c], 0x2b

        $sequence_5 = { 8a4616 240f 3c0a 7519 8b4508 66394608 }
            // n = 6, score = 200
            //   8a4616               | mov                 al, byte ptr [esi + 0x16]
            //   240f                 | and                 al, 0xf
            //   3c0a                 | cmp                 al, 0xa
            //   7519                 | jne                 0x1b
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   66394608             | cmp                 word ptr [esi + 8], ax

        $sequence_6 = { 894f34 8b4b1c 0f299d70ffffff 0f29ad40ffffff 0f29a550ffffff 0f29bdc0fdffff }
            // n = 6, score = 200
            //   894f34               | mov                 dword ptr [edi + 0x34], ecx
            //   8b4b1c               | mov                 ecx, dword ptr [ebx + 0x1c]
            //   0f299d70ffffff       | movaps              xmmword ptr [ebp - 0x90], xmm3
            //   0f29ad40ffffff       | movaps              xmmword ptr [ebp - 0xc0], xmm5
            //   0f29a550ffffff       | movaps              xmmword ptr [ebp - 0xb0], xmm4
            //   0f29bdc0fdffff       | movaps              xmmword ptr [ebp - 0x240], xmm7

        $sequence_7 = { 0f100e 894df4 8b4df0 660fefc8 0f104610 0f110a 0f104f10 }
            // n = 7, score = 200
            //   0f100e               | movups              xmm1, xmmword ptr [esi]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   660fefc8             | pxor                xmm1, xmm0
            //   0f104610             | movups              xmm0, xmmword ptr [esi + 0x10]
            //   0f110a               | movups              xmmword ptr [edx], xmm1
            //   0f104f10             | movups              xmm1, xmmword ptr [edi + 0x10]

        $sequence_8 = { 6800020000 51 50 e8???????? 0fa4c209 c1e009 898338810200 }
            // n = 7, score = 200
            //   6800020000           | push                0x200
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   0fa4c209             | shld                edx, eax, 9
            //   c1e009               | shl                 eax, 9
            //   898338810200         | mov                 dword ptr [ebx + 0x28138], eax

        $sequence_9 = { 41 83f810 72ef 5f }
            // n = 4, score = 200
            //   41                   | inc                 ecx
            //   83f810               | cmp                 eax, 0x10
            //   72ef                 | jb                  0xfffffff1
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 172032
}